package com.hisavana.topon.adapter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.ViewGroup;

import com.anythink.splashad.unitgroup.api.CustomSplashAdapter;
import com.cloud.hisavana.sdk.api.adx.TSplashView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.hisavana.topon.util.AdapterUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.manager.HisavanaManager;

import java.util.Map;

/**
 * Created  ON 2022/7/26
 *
 * @author :fangxuhui
 */
public class HisavanaSplashAdapter extends CustomSplashAdapter {

    private String unit_id;
    private TSplashView mTSplash;

    @Override
    public void show(Activity activity, ViewGroup viewGroup) {
       AdapterUtil.logD("HisavanaSplashAdapter ---->show == "+ unit_id);
        if (activity!=null && !activity.isFinishing() && mTSplash != null && viewGroup!=null) {
            viewGroup.removeAllViews();
            viewGroup.addView(mTSplash);
            mTSplash.show();
        }
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        if (map != null && map.containsKey(Constants.UNIT_ID)) {
            unit_id = (String) map.get(Constants.UNIT_ID);
        }
        if(TextUtils.isEmpty(unit_id)){
            AdapterUtil.logE("HisavanaSplashAdapter ------->"+Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
       AdapterUtil.logD("HisavanaSplashAdapter ------->  unit_id == "+ unit_id);
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if(mTSplash == null){
                    mTSplash = new TSplashView(context, unit_id);
                    mTSplash.setListener(listener);
                    mTSplash.setSkipListener(skipListener);
                }
                mTSplash.setPlacementId(unit_id);
                mTSplash.loadAd();
            }
        });

    }

    @Override
    public void destory() {
        AdapterUtil.logD("HisavanaSplashAdapter ------->  destory  ");
        if (mTSplash != null) {
            mTSplash.destroy();
            mTSplash = null;
        }
    }

    @Override
    public String getNetworkPlacementId() {
        return unit_id;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    @Override
    public boolean isAdReady() {
        return mTSplash == null ? false : mTSplash.isReady();
    }


    private AdListener listener = new AdListener() {
        @Override
        public void onAdLoaded() {
            super.onAdLoaded();
           AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdLoaded ");
            if(mLoadListener!=null){
                mLoadListener.onAdCacheLoaded();
            }

        }

        @Override
        public void onAdClosed() {
            super.onAdClosed();
           AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdClosed ");
            if (mImpressionListener != null) {
                mImpressionListener.onSplashAdDismiss();
            }
        }

        @Override
        public void onAdShow() {
            super.onAdShow();
           AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdShow");
            if (mImpressionListener != null) {
                mImpressionListener.onSplashAdShow();
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
            super.onAdClicked(pointBean);
           AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdClicked");
            if (mImpressionListener != null) {
                mImpressionListener.onSplashAdClicked();
                mImpressionListener.onSplashAdDismiss();
            }
        }

        @Override
        public void onError(TaErrorCode adError) {
            super.onError(adError);
           AdapterUtil.logD("HisavanaSplashAdapter ------->  onError--->"+adError.getErrorMessage());
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError(adError.getErrorCode()+"",adError.getErrorMessage());
            }
        }

        @Override
        public void onTimeOut() {
            super.onTimeOut();
           AdapterUtil.logW("HisavanaSplashAdapter ------->  onTimeOut");
            if(mLoadListener!=null){
                mLoadListener.onAdLoadError("",Constants.Error.ERROR_LOAD_AD_TIMEOUT);
            }
        }
    };

    private OnSkipListener skipListener = new OnSkipListener() {
        @Override
        public void onClick() {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onClick");
            if(mImpressionListener!=null){
                mImpressionListener.onSplashAdDismiss();
            }
        }


        @Override
        public void onTimeEnd() {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onTimeEnd");
            if(mImpressionListener!=null){
                mImpressionListener.onSplashAdDismiss();
            }
        }
    };
}
