/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.topon.adapter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.core.api.BaseAd;
import com.anythink.interstitial.unitgroup.api.CustomInterstitialAdapter;
import com.cloud.hisavana.sdk.api.adx.TInterstitial;
import com.cloud.hisavana.sdk.api.adx.TSplashView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.cache.AdCache;
import com.hisavana.topon.manager.HisavanaManager;
import com.hisavana.topon.util.AdapterUtil;
import com.transsion.core.CoreUtil;
import java.util.Map;

public class HisavanaInterstitialAdapter
extends CustomInterstitialAdapter {
    public String unit_id = "";
    public TInterstitial mTInterstitial;
    public Context context;
    public AdListener listener = new AdListener(){

        public void onError(TaErrorCode taErrorCode) {
            AdapterUtil.logE("HisavanaInterstitialAdapter   onError ---->" + taErrorCode.getErrorMessage());
            if (HisavanaInterstitialAdapter.this.mLoadListener != null) {
                HisavanaInterstitialAdapter.this.mLoadListener.onAdLoadError(taErrorCode.getErrorCode() + "", taErrorCode.getErrorMessage());
            }
        }

        public void onAdLoaded() {
            AdapterUtil.logD("HisavanaInterstitialAdapter   onAdLoaded ");
            if (HisavanaInterstitialAdapter.this.mLoadListener != null) {
                HisavanaInterstitialAdapter.this.mLoadListener.onAdCacheLoaded(new BaseAd[0]);
            }
        }

        public void onAdClicked(DownUpPointBean downUpPointBean) {
            AdapterUtil.logD("HisavanaInterstitialAdapter   onAdClicked ");
            if (HisavanaInterstitialAdapter.this.mImpressListener != null) {
                HisavanaInterstitialAdapter.this.mImpressListener.onInterstitialAdClicked();
            }
        }

        public void onAdShow() {
            AdapterUtil.logD("HisavanaInterstitialAdapter   onAdShow ");
            if (HisavanaInterstitialAdapter.this.mImpressListener != null) {
                HisavanaInterstitialAdapter.this.mImpressListener.onInterstitialAdShow();
            }
        }

        public void onTimeOut() {
            AdapterUtil.logW("HisavanaInterstitialAdapter   onTimeOut");
            if (HisavanaInterstitialAdapter.this.mLoadListener != null) {
                HisavanaInterstitialAdapter.this.mLoadListener.onAdLoadError("", "load ad time out");
            }
        }

        public void onAdClosed() {
            AdapterUtil.logD("HisavanaInterstitialAdapter   onAdClosed");
            if (HisavanaInterstitialAdapter.this.mImpressListener != null) {
                HisavanaInterstitialAdapter.this.mImpressListener.onInterstitialAdClose();
            }
        }

        public void onBiddingSuccess(BidInfo bidInfo) {
            AdapterUtil.logD("HisavanaInterstitialAdapter---->   onBidding ");
            if (HisavanaInterstitialAdapter.this.mBiddingListener == null) {
                return;
            }
            AdCache.getInstance().putBidInfo(HisavanaInterstitialAdapter.this.unit_id, bidInfo);
            if (bidInfo != null) {
                AdapterUtil.logD("HisavanaInterstitialAdapter---->   onBidding --->price =" + bidInfo.getPrice());
                HisavanaInterstitialAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.success((double)bidInfo.getPrice(), (String)bidInfo.getBiddingToken(), null, (ATAdConst.CURRENCY)ATAdConst.CURRENCY.USD));
            } else {
                HisavanaInterstitialAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.fail((String)"bidding failed"));
            }
        }

        public void onBiddingFailed(@NonNull TaErrorCode taErrorCode) {
            3 v0 = this;
            super.onBiddingFailed(taErrorCode);
            AdapterUtil.logD("HisavanaInterstitialAdapter---->  onBiddingFailed ----->" + taErrorCode.getErrorMessage());
            if (v0.HisavanaInterstitialAdapter.this.mBiddingListener != null) {
                HisavanaInterstitialAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.fail((String)taErrorCode.getErrorMessage()));
            }
        }
    };

    private void loadAd(final boolean bl) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                if (HisavanaInterstitialAdapter.this.mTInterstitial == null) {
                    HisavanaInterstitialAdapter hisavanaInterstitialAdapter = HisavanaInterstitialAdapter.this;
                    HisavanaInterstitialAdapter.access$102(hisavanaInterstitialAdapter, new TInterstitial(hisavanaInterstitialAdapter.unit_id));
                }
                2 v0 = this;
                v0.HisavanaInterstitialAdapter.this.mTInterstitial.setListener(HisavanaInterstitialAdapter.this.listener);
                v0.HisavanaInterstitialAdapter.this.mTInterstitial.setPlacementId(HisavanaInterstitialAdapter.this.unit_id);
                if (v0.bl) {
                    HisavanaInterstitialAdapter.this.mTInterstitial.retrieveBid();
                    AdCache.getInstance().putAd(HisavanaInterstitialAdapter.this.unit_id, HisavanaInterstitialAdapter.this.mTInterstitial);
                } else {
                    HisavanaInterstitialAdapter.this.mTInterstitial.loadAd();
                }
            }
        });
    }

    private boolean isHorizontalScreen() {
        int n = CoreUtil.getContext().getResources().getConfiguration().orientation;
        AdapterUtil.logW("HisavanaInterstitialAdapter -----> screen ===" + n);
        return n == 2;
    }

    public static /* synthetic */ TInterstitial access$102(HisavanaInterstitialAdapter hisavanaInterstitialAdapter, TInterstitial tInterstitial) {
        hisavanaInterstitialAdapter.mTInterstitial = tInterstitial;
        return tInterstitial;
    }

    public void show(Activity activity) {
        HisavanaInterstitialAdapter hisavanaInterstitialAdapter = hisavanaInterstitialAdapter.mTInterstitial;
        if (hisavanaInterstitialAdapter != null) {
            hisavanaInterstitialAdapter.show();
        }
    }

    public boolean startBiddingRequest(Context context, Map<String, Object> map, Map<String, Object> map2, ATBiddingListener aTBiddingListener) {
        this.context = context;
        this.mBiddingListener = aTBiddingListener;
        if (map != null && map.containsKey("unit_id")) {
            try {
                this.unit_id = (String)map.get("unit_id");
            }
            catch (Exception exception) {}
        }
        if (TextUtils.isEmpty((CharSequence)this.unit_id)) {
            AdapterUtil.logE("HisavanaInterstitialAdapter -------> startBiddingRequest----> Hisavana unit id is empty");
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
            }
        } else {
            AdapterUtil.logD("HisavanaInterstitialAdapter ------->   startBiddingRequest----> unit_id == " + this.unit_id);
            this.loadAd(true);
        }
        return true;
    }

    public void loadCustomNetworkAd(Context object, Map<String, Object> map, Map<String, Object> map2) {
        this.context = object;
        if (map == null) {
            AdapterUtil.logD("HisavanaInterstitialAdapter -------> loadCustomNetworkAd ----> map is null or empty ");
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
            }
            return;
        }
        if (map.containsKey("unit_id")) {
            this.unit_id = (String)map.get("unit_id");
            if (map.containsKey("payload") && (object = AdCache.getInstance().getAd(this.unit_id)) != null && object instanceof TSplashView) {
                this.mTInterstitial = (TInterstitial)object;
                this.mTInterstitial.setListener(this.listener);
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        HisavanaInterstitialAdapter.this.mTInterstitial.loadAd(AdCache.getInstance().getBiddingInfo(HisavanaInterstitialAdapter.this.unit_id));
                    }
                });
                return;
            }
            AdapterUtil.logD("HisavanaInterstitialAdapter --->loadCustomNetworkAd -------> unit_id=" + this.unit_id);
            this.loadAd(false);
            return;
        }
        AdapterUtil.logE("HisavanaInterstitialAdapter --->loadCustomNetworkAd ------->Hisavana unit id is empty");
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
        }
    }

    public void destory() {
        TInterstitial tInterstitial = this.mTInterstitial;
        if (tInterstitial != null) {
            tInterstitial.destroy();
            this.mTInterstitial = null;
        }
        AdCache.getInstance().remove(this.unit_id);
    }

    public String getNetworkPlacementId() {
        return this.unit_id;
    }

    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    public boolean isAdReady() {
        HisavanaInterstitialAdapter hisavanaInterstitialAdapter = hisavanaInterstitialAdapter.mTInterstitial;
        return hisavanaInterstitialAdapter == null ? false : hisavanaInterstitialAdapter.isReady();
    }
}

