/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.topon.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.core.api.BaseAd;
import com.anythink.nativead.unitgroup.api.CustomNativeAdapter;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.ad.HisavanaNativeAd;
import com.hisavana.topon.cache.AdCache;
import com.hisavana.topon.manager.HisavanaManager;
import com.hisavana.topon.util.AdapterUtil;
import java.util.List;
import java.util.Map;

public class HisavanaNativeAdapter
extends CustomNativeAdapter {
    public String unit_id = "";
    public TNative mTNative;
    public Context context;
    public AdListener listener = new AdListener(){

        public void onMediaDownloaded(TaNativeInfo taNativeInfo) {
            AdapterUtil.logD(">onMediaDownloaded , image = " + taNativeInfo.isMediaCached());
        }

        public void onError(TaErrorCode taErrorCode) {
            AdapterUtil.logE("HisavanaNativeAdapter --->onError--->" + taErrorCode.getErrorMessage());
            if (HisavanaNativeAdapter.this.mLoadListener != null) {
                HisavanaNativeAdapter.this.mLoadListener.onAdLoadError(taErrorCode.getErrorCode() + "", taErrorCode.getErrorMessage());
            }
        }

        public void onAdLoaded(List<TaNativeInfo> taNativeInfo) {
            AdapterUtil.logD("HisavanaNativeAdapter --->onAdLoaded");
            if (HisavanaNativeAdapter.this.mLoadListener != null) {
                if (taNativeInfo != null && !taNativeInfo.isEmpty() && (taNativeInfo = taNativeInfo.get(0)) != null) {
                    HisavanaNativeAd hisavanaNativeAd;
                    HisavanaNativeAd hisavanaNativeAd2 = hisavanaNativeAd;
                    new HisavanaNativeAd(HisavanaNativeAdapter.this.context, HisavanaNativeAdapter.this.mTNative, taNativeInfo).setAdLogoView((View)new AdChoicesView(HisavanaNativeAdapter.this.context));
                    HisavanaNativeAdapter.this.mLoadListener.onAdCacheLoaded(new BaseAd[]{hisavanaNativeAd2});
                    return;
                }
                HisavanaNativeAdapter.this.mLoadListener.onAdLoadError("", "ad result is empty");
            }
        }

        public void onAdShow() {
            AdapterUtil.logD("HisavanaNativeAdapter ------->  onAdShow");
        }

        public void onTimeOut() {
            AdapterUtil.logW("HisavanaNativeAdapter ------->  onTimeOut");
            if (HisavanaNativeAdapter.this.mLoadListener != null) {
                HisavanaNativeAdapter.this.mLoadListener.onAdLoadError("", "load ad time out");
            }
        }

        public void onAdClicked(DownUpPointBean downUpPointBean) {
            AdapterUtil.logD("HisavanaNativeAdapter ------->  onAdClicked");
        }

        public void onBiddingSuccess(BidInfo bidInfo) {
            AdapterUtil.logD("HisavanaNativeAdapter---->   onBidding ");
            if (HisavanaNativeAdapter.this.mBiddingListener == null) {
                return;
            }
            AdCache.getInstance().putBidInfo(HisavanaNativeAdapter.this.unit_id, bidInfo);
            if (bidInfo != null) {
                AdapterUtil.logD("HisavanaNativeAdapter---->   onBidding --->price =" + bidInfo.getPrice());
                HisavanaNativeAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.success((double)bidInfo.getPrice(), (String)bidInfo.getBiddingToken(), null, (ATAdConst.CURRENCY)ATAdConst.CURRENCY.USD));
            } else {
                HisavanaNativeAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.fail((String)"bidding failed"));
            }
        }

        public void onBiddingFailed(@NonNull TaErrorCode taErrorCode) {
            3 v0 = this;
            AdapterUtil.logD("HisavanaNativeAdapter---->  onBiddingFailed ----->" + taErrorCode.getErrorMessage());
            super.onBiddingFailed(taErrorCode);
            if (v0.HisavanaNativeAdapter.this.mBiddingListener != null) {
                HisavanaNativeAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.fail((String)taErrorCode.getErrorMessage()));
            }
        }
    };

    private void loadAd(final boolean bl) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                if (HisavanaNativeAdapter.this.mTNative == null) {
                    HisavanaNativeAdapter hisavanaNativeAdapter = HisavanaNativeAdapter.this;
                    HisavanaNativeAdapter.access$102(hisavanaNativeAdapter, new TNative(hisavanaNativeAdapter.unit_id));
                }
                2 v0 = this;
                v0.HisavanaNativeAdapter.this.mTNative.setListener(HisavanaNativeAdapter.this.listener);
                v0.HisavanaNativeAdapter.this.mTNative.setPlacementId(HisavanaNativeAdapter.this.unit_id);
                if (v0.bl) {
                    HisavanaNativeAdapter.this.mTNative.retrieveBid();
                    AdCache.getInstance().putAd(HisavanaNativeAdapter.this.unit_id, HisavanaNativeAdapter.this.mTNative);
                } else {
                    HisavanaNativeAdapter.this.mTNative.loadAd();
                }
            }
        });
    }

    public static /* synthetic */ TNative access$102(HisavanaNativeAdapter hisavanaNativeAdapter, TNative tNative) {
        hisavanaNativeAdapter.mTNative = tNative;
        return tNative;
    }

    public boolean startBiddingRequest(Context context, Map<String, Object> map, Map<String, Object> map2, ATBiddingListener aTBiddingListener) {
        this.context = context;
        this.mBiddingListener = aTBiddingListener;
        if (map != null && map.containsKey("unit_id")) {
            try {
                this.unit_id = (String)map.get("unit_id");
            }
            catch (Exception exception) {}
            AdapterUtil.logD("HisavanaNativeAdapter ---> startBiddingRequest ------->Hisavana unit id is empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.unit_id)) {
            AdapterUtil.logE("HisavanaNativeAdapter ------->Hisavana unit id is empty");
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
            }
        } else {
            AdapterUtil.logD("HisavanaNativeAdapter -------> startBiddingRequest---->   unit_id == " + this.unit_id);
            this.loadAd(true);
        }
        return true;
    }

    public void loadCustomNetworkAd(Context object, Map<String, Object> map, Map<String, Object> map2) {
        this.context = object;
        if (map == null) {
            AdapterUtil.logD("HisavanaNativeAdapter -------> loadCustomNetworkAd ----> map is null or empty ");
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
            }
            return;
        }
        if (map.containsKey("unit_id")) {
            this.unit_id = (String)map.get("unit_id");
            if (map.containsKey("payload") && (object = AdCache.getInstance().getAd(this.unit_id)) != null && object instanceof TNative) {
                this.mTNative = (TNative)object;
                this.mTNative.setListener(this.listener);
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        HisavanaNativeAdapter.this.mTNative.loadAd(AdCache.getInstance().getBiddingInfo(HisavanaNativeAdapter.this.unit_id));
                    }
                });
                return;
            }
            AdapterUtil.logD("HisavanaNativeAdapter --->loadCustomNetworkAd -------> unit_id=" + this.unit_id);
            this.loadAd(false);
            return;
        }
        AdapterUtil.logE("HisavanaNativeAdapter --->loadCustomNetworkAd ------->Hisavana unit id is empty");
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
        }
    }

    public void destory() {
        AdapterUtil.logD("HisavanaNativeAdapter --->destory");
        TNative tNative = this.mTNative;
        if (tNative != null) {
            tNative.destroy();
            this.mTNative = null;
        }
        AdCache.getInstance().remove(this.unit_id);
    }

    public String getNetworkPlacementId() {
        return this.unit_id;
    }

    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }
}

