/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.topon.adapter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.core.api.BaseAd;
import com.anythink.splashad.unitgroup.api.CustomSplashAdapter;
import com.cloud.hisavana.sdk.api.adx.TSplashView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.cache.AdCache;
import com.hisavana.topon.manager.HisavanaManager;
import com.hisavana.topon.util.AdapterUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class HisavanaSplashAdapter
extends CustomSplashAdapter {
    public String unit_id;
    public TSplashView mTSplash;
    public Context context;
    public AtomicBoolean isShowing = new AtomicBoolean(false);
    public ViewGroup container;
    public AdListener listener = new AdListener(){

        public void onAdLoaded() {
            3 v0 = this;
            super.onAdLoaded();
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdLoaded ");
            if (v0.HisavanaSplashAdapter.this.mLoadListener != null) {
                HisavanaSplashAdapter.this.mLoadListener.onAdCacheLoaded(new BaseAd[0]);
            }
        }

        public void onAdClosed() {
            super.onAdClosed();
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdClosed ");
        }

        public void onAdShow() {
            3 v0 = this;
            super.onAdShow();
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdShow");
            if (v0.HisavanaSplashAdapter.this.mImpressionListener != null) {
                HisavanaSplashAdapter.this.mImpressionListener.onSplashAdShow();
            }
        }

        public void onAdClicked(DownUpPointBean downUpPointBean) {
            3 v0 = this;
            super.onAdClicked(downUpPointBean);
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdClicked");
            if (v0.HisavanaSplashAdapter.this.mImpressionListener != null) {
                3 v1 = this;
                v1.HisavanaSplashAdapter.this.mImpressionListener.onSplashAdClicked();
                v1.HisavanaSplashAdapter.this.mImpressionListener.onSplashAdDismiss();
            }
        }

        public void onError(TaErrorCode taErrorCode) {
            3 v0 = this;
            super.onError(taErrorCode);
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onError--->" + taErrorCode.getErrorMessage());
            if (v0.HisavanaSplashAdapter.this.mLoadListener != null) {
                HisavanaSplashAdapter.this.mLoadListener.onAdLoadError("", taErrorCode.getErrorMessage());
            }
        }

        public void onTimeOut() {
            3 v0 = this;
            super.onTimeOut();
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onTimeOut");
            if (v0.HisavanaSplashAdapter.this.mLoadListener != null) {
                HisavanaSplashAdapter.this.mLoadListener.onAdLoadError("", "load ad time out");
            }
        }

        public void onBiddingSuccess(BidInfo bidInfo) {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onBidding");
            if (HisavanaSplashAdapter.this.mBiddingListener == null) {
                return;
            }
            AdCache.getInstance().putBidInfo(HisavanaSplashAdapter.this.unit_id, bidInfo);
            if (bidInfo != null) {
                AdapterUtil.logD("HisavanaSplashAdapter---->   onBidding --->price =" + bidInfo.getPrice());
                HisavanaSplashAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.success((double)bidInfo.getPrice(), (String)bidInfo.getBiddingToken(), null, (ATAdConst.CURRENCY)ATAdConst.CURRENCY.USD));
            } else {
                HisavanaSplashAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.fail((String)"bidding failed"));
            }
        }

        public void onBiddingFailed(@NonNull TaErrorCode taErrorCode) {
            3 v0 = this;
            super.onBiddingFailed(taErrorCode);
            AdapterUtil.logD("HisavanaSplashAdapter----> onBiddingFailed ----->" + taErrorCode.getErrorMessage());
            if (v0.HisavanaSplashAdapter.this.mBiddingListener != null) {
                HisavanaSplashAdapter.this.mBiddingListener.onC2SBidResult(ATBiddingResult.fail((String)taErrorCode.getErrorMessage()));
            }
        }
    };
    public OnSkipListener skipListener = new OnSkipListener(){

        public void onClick() {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onClick");
            HisavanaSplashAdapter.this.dismissCallback();
        }

        public void onTimeEnd() {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onTimeEnd");
            HisavanaSplashAdapter.this.dismissCallback();
        }
    };

    private void loadAd(final boolean bl) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                if (HisavanaSplashAdapter.this.mTSplash == null) {
                    HisavanaSplashAdapter hisavanaSplashAdapter = HisavanaSplashAdapter.this;
                    HisavanaSplashAdapter.access$102(hisavanaSplashAdapter, new TSplashView(hisavanaSplashAdapter.context, HisavanaSplashAdapter.this.unit_id));
                }
                2 v0 = this;
                v0.HisavanaSplashAdapter.this.mTSplash.setListener(HisavanaSplashAdapter.this.listener);
                v0.HisavanaSplashAdapter.this.mTSplash.setSkipListener(HisavanaSplashAdapter.this.skipListener);
                v0.HisavanaSplashAdapter.this.mTSplash.setPlacementId(HisavanaSplashAdapter.this.unit_id);
                if (v0.bl) {
                    AdCache.getInstance().putAd(HisavanaSplashAdapter.this.unit_id, HisavanaSplashAdapter.this.mTSplash);
                    HisavanaSplashAdapter.this.mTSplash.retrieveBid();
                } else {
                    HisavanaSplashAdapter.this.mTSplash.loadAd();
                }
            }
        });
    }

    private void dismissCallback() {
        AtomicBoolean atomicBoolean = this.isShowing;
        if (atomicBoolean != null && atomicBoolean.get() && this.mImpressionListener != null) {
            HisavanaSplashAdapter hisavanaSplashAdapter = this;
            hisavanaSplashAdapter.isShowing.set(false);
            hisavanaSplashAdapter.mImpressionListener.onSplashAdDismiss();
        }
    }

    private Boolean getChildA(View view) {
        Boolean bl = false;
        if (view instanceof ViewGroup) {
            view = (ViewGroup)view;
            for (int i = 0; i < view.getChildCount(); ++i) {
                View view2 = view.getChildAt(i);
                if (view2.getTag() != null && String.valueOf(view2.getTag()).equals("1000")) {
                    return true;
                }
                bl = bl.booleanValue() || this.getChildA(view2).booleanValue();
            }
        }
        return bl;
    }

    public static /* synthetic */ TSplashView access$102(HisavanaSplashAdapter hisavanaSplashAdapter, TSplashView tSplashView) {
        hisavanaSplashAdapter.mTSplash = tSplashView;
        return tSplashView;
    }

    public void show(Activity activity, ViewGroup viewGroup) {
        AdapterUtil.logD("HisavanaSplashAdapter ---->show == " + this.unit_id);
        if (activity != null && !activity.isFinishing() && this.mTSplash != null && viewGroup != null) {
            if (activity != viewGroup.getContext()) {
                return;
            }
            HisavanaSplashAdapter hisavanaSplashAdapter = this;
            this.container = viewGroup;
            viewGroup.removeAllViews();
            viewGroup.addView((View)this.mTSplash);
            hisavanaSplashAdapter.mTSplash.show();
            hisavanaSplashAdapter.isShowing.set(true);
        }
    }

    public boolean startBiddingRequest(Context context, Map<String, Object> map, Map<String, Object> map2, ATBiddingListener aTBiddingListener) {
        this.context = context;
        this.mBiddingListener = aTBiddingListener;
        if (map != null && map.containsKey("unit_id")) {
            try {
                this.unit_id = (String)map.get("unit_id");
            }
            catch (Exception exception) {}
        }
        if (TextUtils.isEmpty((CharSequence)this.unit_id)) {
            AdapterUtil.logE("HisavanaSplashAdapter -------> startBiddingRequest----> Hisavana unit id is empty");
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
            }
        } else {
            AdapterUtil.logD("HisavanaSplashAdapter -------> startBiddingRequest---->  unit_id == " + this.unit_id);
            this.loadAd(true);
        }
        return true;
    }

    public void loadCustomNetworkAd(Context object, Map<String, Object> map, Map<String, Object> map2) {
        this.context = object;
        if (map == null) {
            AdapterUtil.logD("HisavanaSplashAdapter -------> loadCustomNetworkAd ----> map is null or empty ");
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
            }
            return;
        }
        if (map.containsKey("unit_id")) {
            this.unit_id = (String)map.get("unit_id");
            if (map.containsKey("payload") && (object = AdCache.getInstance().getAd(this.unit_id)) != null && object instanceof TSplashView) {
                HisavanaSplashAdapter hisavanaSplashAdapter = this;
                AdapterUtil.logD("HisavanaSplashAdapter ---> loadCustomNetworkAd ------->bidding success---> " + object);
                hisavanaSplashAdapter.mTSplash = (TSplashView)object;
                hisavanaSplashAdapter.mTSplash.setListener(this.listener);
                hisavanaSplashAdapter.mTSplash.setSkipListener(this.skipListener);
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        HisavanaSplashAdapter.this.mTSplash.loadAd(AdCache.getInstance().getBiddingInfo(HisavanaSplashAdapter.this.unit_id));
                    }
                });
                return;
            }
            AdapterUtil.logD("HisavanaSplashAdapter --->loadCustomNetworkAd -------> unit_id=" + this.unit_id);
            this.loadAd(false);
            return;
        }
        AdapterUtil.logE("HisavanaSplashAdapter --->loadCustomNetworkAd ------->Hisavana unit id is empty");
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoadError("", "Hisavana unit id is empty");
        }
    }

    public void destory() {
        AdapterUtil.logD("HisavanaSplashAdapter ------->  destory  ");
        TSplashView tSplashView = this.mTSplash;
        if (tSplashView != null) {
            tSplashView.destroy();
            this.mTSplash = null;
        }
        AdCache.getInstance().remove(this.unit_id);
        this.dismissCallback();
    }

    public String getNetworkPlacementId() {
        return this.unit_id;
    }

    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    public boolean isAdReady() {
        HisavanaSplashAdapter hisavanaSplashAdapter = hisavanaSplashAdapter.mTSplash;
        return hisavanaSplashAdapter == null ? false : hisavanaSplashAdapter.isReady();
    }
}

