package com.hisavana.topon.ad;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.anythink.nativead.api.ATNativePrepareInfo;
import com.anythink.nativead.unitgroup.api.CustomNativeAd;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.api.view.MediaView;
import com.cloud.hisavana.sdk.api.view.TNativeView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.hisavana.topon.util.AdapterUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created  ON 2022/7/27
 *
 * @author :fangxuhui
 */
public class HisavanaNativeAd extends CustomNativeAd {

    private Context context;
    private TaNativeInfo taNativeInfo;
    private TNative tNative;
    private ImageView iconView;
    private MediaView mediaView;
    private AdChoicesView adChoicesView;
    /**
     * 是否模板
     */
    private boolean isNativeExpress;
    private TNativeView tNativeView;

    public HisavanaNativeAd(Context context, TNative tNative, TaNativeInfo taNativeInfo) {
        this.context = context;
        this.tNative = tNative;
        this.taNativeInfo = taNativeInfo;
    }

    @Override
    public String getTitle() {
        return taNativeInfo == null ? "" : taNativeInfo.getTitle();
    }

    @Override
    public String getDescriptionText() {
        return taNativeInfo == null ? "" : taNativeInfo.getDescription();
    }

    @Override
    public ViewGroup getCustomAdContainer() {
        tNativeView = new TNativeView(context);
        return tNativeView;
    }

    @Override
    public View getAdMediaView(Object... object) {
        mediaView = new MediaView(context);
        return mediaView;
    }

    @Override
    public View getAdIconView() {
        iconView = new ImageView(context);
        if (taNativeInfo != null && taNativeInfo.getIconImage() != null && taNativeInfo.getIconImage().getDrawable() != null) {
            iconView.setImageDrawable(taNativeInfo.getIconImage().getDrawable());
        }
        iconView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        return iconView;
    }

    @Override
    public boolean isNativeExpress() {
        return false;
    }

    @Override
    public void prepare(View view, ATNativePrepareInfo nativePrepareInfo) {
        if (view == null) {
            AdapterUtil.logW("HisavanaNativeAd ---> prepare :view is null");
            return;
        }
        if (taNativeInfo != null && tNativeView != null && mediaView != null && nativePrepareInfo != null) {
            List<View> clickViewList = nativePrepareInfo.getClickViewList();
            tNativeView.destroy();
            tNativeView.addView(nativePrepareInfo.getParentView());
            tNativeView.setIconView(nativePrepareInfo.getIconView());
            tNativeView.setMediaView(mediaView, ImageView.ScaleType.FIT_CENTER);
            tNativeView.setAdChoiceView((AdChoicesView) nativePrepareInfo.getAdLogoView());
            tNativeView.setupViews(taNativeInfo);
            tNative.registerViews(tNativeView, clickViewList, taNativeInfo);
        }else{
            AdapterUtil.logE("HisavanaNativeAd ---> prepare : tNativeView  ="+tNativeView);
            AdapterUtil.logE("HisavanaNativeAd ---> prepare : mediaView  ="+mediaView);
            AdapterUtil.logE("HisavanaNativeAd ---> prepare : nativePrepareInfo  ="+nativePrepareInfo);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        AdapterUtil.logD("HisavanaNativeAd ---> destroy");
        if (tNativeView != null) {
            tNativeView.destroy();
        }
    }

    public void setNativeExpress(boolean nativeExpress) {
        isNativeExpress = nativeExpress;
    }

}

