package com.hisavana.topon.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.anythink.banner.unitgroup.api.CustomBannerAdapter;
import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.hisavana.sdk.api.adx.TSplashView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.hisavana.topon.cache.AdCache;
import com.hisavana.topon.util.AdapterUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.manager.HisavanaManager;

import java.util.Map;
import java.util.UUID;

/**
 * Created  ON 2022/7/25
 *
 * @author :fangxuhui
 */
public class HisavanaBannerAdapter extends CustomBannerAdapter {

    private String unit_id = "";
    private TBannerView mBannerView;
    private Context context;

    @Override
    public View getBannerView() {
        return mBannerView;
    }

    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        this.context = context;
        mBiddingListener = biddingListener;
        if (serverExtra != null && serverExtra.containsKey(Constants.UNIT_ID)) {
            try {
                unit_id = (String) serverExtra.get(Constants.UNIT_ID);
            } catch (Exception e) {
            }
        }
        if (TextUtils.isEmpty(unit_id)) {
            AdapterUtil.logE("HisavanaBannerAdapter -------> startBiddingRequest----> " + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
        } else {
            AdapterUtil.logD("HisavanaBannerAdapter ------->   startBiddingRequest----> unit_id == " + unit_id);
            loadAd(true);
        }
        return true;
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        this.context = context;
        if (map == null) {
            AdapterUtil.logD("HisavanaBannerAdapter -------> loadCustomNetworkAd ----> map is null or empty ");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.UNIT_ID)) {
            unit_id = (String) map.get(Constants.UNIT_ID);
        } else {
            AdapterUtil.logE("HisavanaBannerAdapter --->loadCustomNetworkAd ------->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.PAYLOAD)) {
            Object ad = AdCache.getInstance().getAd(unit_id);
            if (ad != null && ad instanceof TSplashView) {
                mBannerView = (TBannerView) ad;
                mBannerView.setListener(listener);
                Preconditions.runOnMainThread(new Preconditions.Callback() {
                    @Override
                    public void onRun() {
                        mBannerView.loadAd(AdCache.getInstance().getBiddingInfo(unit_id));
                    }
                });
                return;
            }
        }
        AdapterUtil.logD("HisavanaBannerAdapter --->loadCustomNetworkAd -------> unit_id=" + unit_id);
        loadAd(false);
    }

    @Override
    public void destory() {
       AdapterUtil.logD( "HisavanaBannerAdapter  destory");
        if (mBannerView != null) {
            mBannerView.destroy();
            mBannerView = null;
        }
        AdCache.getInstance().remove(unit_id);
    }

    @Override
    public String getNetworkPlacementId() {
        return unit_id;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    private void loadAd(boolean isBidding) {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mBannerView == null) {
                    mBannerView = new TBannerView(context, unit_id);
                }
                mBannerView.setListener(listener);
                mBannerView.setPlacementId(unit_id);
                if(isBidding){
                    mBannerView.retrieveBid();
                    AdCache.getInstance().putAd(unit_id,mBannerView);
                }else{
                    mBannerView.loadAd();
                }
            }
        });
    }

    private AdListener listener = new AdListener() {
        @Override
        public void onError(TaErrorCode adError) {
           AdapterUtil.logE( "HisavanaBannerAdapter  onError --->"+adError.getErrorMessage());
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError(adError.getErrorCode() + "", adError.getErrorMessage());
            }
        }

        @Override
        public void onAdLoaded() {
           AdapterUtil.logD( "HisavanaBannerAdapter  onAdLoaded");
            if (mLoadListener != null && mBannerView != null) {
                mBannerView.show();
                mLoadListener.onAdCacheLoaded();
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
           AdapterUtil.logD( "HisavanaBannerAdapter  onAdClicked");
            if (mImpressionEventListener != null) {
                mImpressionEventListener.onBannerAdClicked();
            }
        }

        @Override
        public void onAdShow() {
           AdapterUtil.logD( "HisavanaBannerAdapter  onAdShow");
            if (mImpressionEventListener != null) {
                mImpressionEventListener.onBannerAdShow();
            }
        }

        @Override
        public void onTimeOut() {
           AdapterUtil.logW( "HisavanaBannerAdapter  onTimeOut");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_LOAD_AD_TIMEOUT);
            }
        }

        @Override
        public void onBiddingSuccess(BidInfo bidInfo) {
            AdapterUtil.logD("HisavanaBannerAdapter---->   onBidding ");
            if(mBiddingListener == null){
                return;
            }
            AdCache.getInstance().putBidInfo(unit_id,bidInfo);
            if (bidInfo != null) {
                AdapterUtil.logD("HisavanaBannerAdapter---->   onBidding --->price ="+bidInfo.getPrice());
                mBiddingListener.onC2SBidResult(ATBiddingResult.success(bidInfo.getPrice(), bidInfo.getBiddingToken(), null, ATAdConst.CURRENCY.USD));
            } else {
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(Constants.Error.ERROR_BIDDING_FAILED));
            }
        }

        @Override
        public void onBiddingFailed(@NonNull TaErrorCode taErrorCode) {
            super.onBiddingFailed(taErrorCode);
            AdapterUtil.logD("HisavanaBannerAdapter---->  onBiddingFailed ----->"+taErrorCode.getErrorMessage());
            if(mBiddingListener!=null){
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(taErrorCode.getErrorMessage()));
            }
        }
    };
}
