package com.hisavana.topon.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.interstitial.unitgroup.api.CustomInterstitialAdapter;
import com.cloud.hisavana.sdk.api.adx.TInterstitial;
import com.cloud.hisavana.sdk.api.adx.TSplashView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.cache.AdCache;
import com.hisavana.topon.manager.HisavanaManager;
import com.hisavana.topon.util.AdapterUtil;
import com.transsion.core.CoreUtil;
import java.util.Map;

/**
 * Created  ON 2022/7/26
 *
 * @author :fangxuhui
 */
public class HisavanaInterstitialAdapter extends CustomInterstitialAdapter {

    private String unit_id = "";
    private TInterstitial mTInterstitial;
    private Context context;

    @Override
    public void show(Activity activity) {
        if (mTInterstitial != null) {
            mTInterstitial.show();
        }
    }
    
    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        this.context = context;
        mBiddingListener = biddingListener;
        if (serverExtra != null && serverExtra.containsKey(Constants.UNIT_ID)) {
            try {
                unit_id = (String) serverExtra.get(Constants.UNIT_ID);
            } catch (Exception e) {
            }
        }
        if (TextUtils.isEmpty(unit_id)) {
            AdapterUtil.logE("HisavanaInterstitialAdapter -------> startBiddingRequest----> " + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
        } else {
            AdapterUtil.logD("HisavanaInterstitialAdapter ------->   startBiddingRequest----> unit_id == " + unit_id);
            loadAd(true);
        }
        return true;
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        this.context = context;
        if (map == null) {
            AdapterUtil.logD("HisavanaInterstitialAdapter -------> loadCustomNetworkAd ----> map is null or empty ");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.UNIT_ID)) {
            unit_id = (String) map.get(Constants.UNIT_ID);
        } else {
            AdapterUtil.logE("HisavanaInterstitialAdapter --->loadCustomNetworkAd ------->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.PAYLOAD)) {
            Object ad = AdCache.getInstance().getAd(unit_id);
            if (ad != null && ad instanceof TSplashView) {
                mTInterstitial = (TInterstitial) ad;
                mTInterstitial.setListener(listener);
                Preconditions.runOnMainThread(new Preconditions.Callback() {
                    @Override
                    public void onRun() {
                        mTInterstitial.loadAd(AdCache.getInstance().getBiddingInfo(unit_id));
                    }
                });
                return;
            }
        }
        AdapterUtil.logD("HisavanaInterstitialAdapter --->loadCustomNetworkAd -------> unit_id=" + unit_id);
        loadAd(false);
    }

    @Override
    public void destory() {
        if (mTInterstitial != null){
            mTInterstitial.destroy();
            mTInterstitial = null;
        }
        AdCache.getInstance().remove(unit_id);
    }

    @Override
    public String getNetworkPlacementId() {
        return unit_id;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    @Override
    public boolean isAdReady() {
        return mTInterstitial == null  ? false : mTInterstitial.isReady();
    }

    private void loadAd(boolean isBidding) {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mTInterstitial == null) {
                    mTInterstitial = new TInterstitial(unit_id);
                }
                mTInterstitial.setListener(listener);
                mTInterstitial.setPlacementId(unit_id);
                if(isBidding){
                    mTInterstitial.retrieveBid();
                    AdCache.getInstance().putAd(unit_id,mTInterstitial);
                }else{
                    mTInterstitial.loadAd();
                }
            }
        });
    }

    private boolean isHorizontalScreen() {
        Configuration mConfiguration = CoreUtil.getContext().getResources().getConfiguration();
        //获取屏幕方向
        int ori = mConfiguration.orientation;
        AdapterUtil.logW("HisavanaInterstitialAdapter -----> screen ===" + ori);
        return ori == Configuration.ORIENTATION_LANDSCAPE;
    }
    private AdListener listener = new AdListener() {
        @Override
        public void onError(TaErrorCode adError) {
           AdapterUtil.logE("HisavanaInterstitialAdapter   onError ---->"+adError.getErrorMessage());
            if(mLoadListener!=null){
                mLoadListener.onAdLoadError(adError.getErrorCode()+"",adError.getErrorMessage());
            }
        }

        @Override
        public void onAdLoaded() {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdLoaded ");
            if(mLoadListener!=null){
                mLoadListener.onAdCacheLoaded();
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdClicked ");
            if(mImpressListener!=null){
                mImpressListener.onInterstitialAdClicked();
            }
        }

        @Override
        public void onAdShow() {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdShow ");
            if(mImpressListener!=null){
                mImpressListener.onInterstitialAdShow();
            }
        }

        @Override
        public void onTimeOut() {
           AdapterUtil.logW("HisavanaInterstitialAdapter   onTimeOut");
            if(mLoadListener!=null){
                mLoadListener.onAdLoadError("",Constants.Error.ERROR_LOAD_AD_TIMEOUT);
            }
        }

        @Override
        public void onAdClosed() {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdClosed");
            if(mImpressListener!=null){
                mImpressListener.onInterstitialAdClose();
            }
        }

        @Override
        public void onBiddingSuccess(BidInfo bidInfo) {
            AdapterUtil.logD("HisavanaInterstitialAdapter---->   onBidding ");
            if(mBiddingListener == null){
                return;
            }
            AdCache.getInstance().putBidInfo(unit_id,bidInfo);
            if (bidInfo != null) {
                AdapterUtil.logD("HisavanaInterstitialAdapter---->   onBidding --->price ="+bidInfo.getPrice());
                mBiddingListener.onC2SBidResult(ATBiddingResult.success(bidInfo.getPrice(), bidInfo.getBiddingToken(), null, ATAdConst.CURRENCY.USD));
            } else {
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(Constants.Error.ERROR_BIDDING_FAILED));
            }
        }

        @Override
        public void onBiddingFailed(@NonNull TaErrorCode taErrorCode) {
            super.onBiddingFailed(taErrorCode);
            AdapterUtil.logD("HisavanaInterstitialAdapter---->  onBiddingFailed ----->"+taErrorCode.getErrorMessage());
            if(mBiddingListener!=null){
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(taErrorCode.getErrorMessage()));
            }
        }
    };
}
