package com.hisavana.topon.adapter;


import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.nativead.unitgroup.api.CustomNativeAdapter;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.hisavana.topon.cache.AdCache;
import com.hisavana.topon.util.AdapterUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.ad.HisavanaNativeAd;
import com.hisavana.topon.manager.HisavanaManager;

import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Created  ON 2022/7/26
 *
 * @author :fangxuhui
 */
public class HisavanaNativeAdapter extends CustomNativeAdapter {

    private String unit_id = "";
    private TNative mTNative;
    private Context context;

    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        this.context = context;
        mBiddingListener = biddingListener;
        if (serverExtra != null && serverExtra.containsKey(Constants.UNIT_ID)) {
            try {
                unit_id = (String) serverExtra.get(Constants.UNIT_ID);
            } catch (Exception e) { }
            AdapterUtil.logD("HisavanaNativeAdapter ---> startBiddingRequest ------->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
        }
        if (TextUtils.isEmpty(unit_id)) {
            AdapterUtil.logE("HisavanaNativeAdapter ------->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
        } else {
            AdapterUtil.logD("HisavanaNativeAdapter -------> startBiddingRequest---->   unit_id == " + unit_id);
            loadAd(true);
        }
        return true;
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        this.context = context;
        if (map == null) {
            AdapterUtil.logD("HisavanaNativeAdapter -------> loadCustomNetworkAd ----> map is null or empty ");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.UNIT_ID)) {
            unit_id = (String) map.get(Constants.UNIT_ID);
        } else {
            AdapterUtil.logE("HisavanaNativeAdapter --->loadCustomNetworkAd ------->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.PAYLOAD)) {
            Object ad = AdCache.getInstance().getAd(unit_id);
            if (ad != null && ad instanceof TNative) {
                mTNative = (TNative) ad;
                mTNative.setListener(listener);
                Preconditions.runOnMainThread(new Preconditions.Callback() {
                    @Override
                    public void onRun() {
                        mTNative.loadAd(AdCache.getInstance().getBiddingInfo(unit_id));
                    }
                });
                return;
            }
        }
        AdapterUtil.logD("HisavanaNativeAdapter --->loadCustomNetworkAd -------> unit_id=" + unit_id);
        loadAd(false);
    }

    @Override
    public void destory() {
        AdapterUtil.logD("HisavanaNativeAdapter --->destory");
        if (mTNative != null) {
            mTNative.destroy();
            mTNative = null;
        }
        AdCache.getInstance().remove(unit_id);
    }

    @Override
    public String getNetworkPlacementId() {
        return unit_id;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    private void loadAd(boolean isBidding) {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mTNative == null) {
                    mTNative = new TNative(unit_id);
                }
                mTNative.setListener(listener);
                mTNative.setPlacementId(unit_id);
                if(isBidding){
                    mTNative.retrieveBid();
                    AdCache.getInstance().putAd(unit_id,mTNative);
                }else{
                    mTNative.loadAd();
                }
            }
        });
    }

    /**
     * 回调listener
     */
    private AdListener listener = new AdListener() {

        @Override
        public void onMediaDownloaded(final TaNativeInfo ad) {
            AdapterUtil.logD(">onMediaDownloaded , image = " + ad.isMediaCached());
        }

        @Override
        public void onError(TaErrorCode adError) {
            AdapterUtil.logE("HisavanaNativeAdapter --->onError--->" + adError.getErrorMessage());
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError(adError.getErrorCode() + "", adError.getErrorMessage());
            }
        }

        @Override
        public void onAdLoaded(final List<TaNativeInfo> adInfoList) {
            AdapterUtil.logD("HisavanaNativeAdapter --->onAdLoaded");
            if (mLoadListener != null) {
                if (adInfoList != null && !adInfoList.isEmpty()) {
                    TaNativeInfo taNativeInfo = adInfoList.get(0);
                    if (taNativeInfo != null) {
                        HisavanaNativeAd hisavanaNativeAd = new HisavanaNativeAd(context, mTNative, taNativeInfo);
                        AdChoicesView adChoicesView = new AdChoicesView(context);
                        hisavanaNativeAd.setAdLogoView(adChoicesView);
                        mLoadListener.onAdCacheLoaded(hisavanaNativeAd);
                        return;
                    }
                }
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_AD_EMPTY);
            }
        }

        @Override
        public void onAdShow() {
            AdapterUtil.logD("HisavanaNativeAdapter ------->  onAdShow");
        }

        @Override
        public void onTimeOut() {
            AdapterUtil.logW("HisavanaNativeAdapter ------->  onTimeOut");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_LOAD_AD_TIMEOUT);
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
            AdapterUtil.logD("HisavanaNativeAdapter ------->  onAdClicked");
        }

        @Override
        public void onBiddingSuccess(BidInfo bidInfo) {
            AdapterUtil.logD("HisavanaNativeAdapter---->   onBidding ");
            if(mBiddingListener == null){
                return;
            }
            AdCache.getInstance().putBidInfo(unit_id,bidInfo);
            if (bidInfo != null) {
                AdapterUtil.logD("HisavanaNativeAdapter---->   onBidding --->price ="+bidInfo.getPrice());
                mBiddingListener.onC2SBidResult(ATBiddingResult.success(bidInfo.getPrice(), bidInfo.getBiddingToken(), null, ATAdConst.CURRENCY.USD));
            } else {
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(Constants.Error.ERROR_BIDDING_FAILED));
            }
        }

        @Override
        public void onBiddingFailed(@NonNull TaErrorCode taErrorCode) {
            AdapterUtil.logD("HisavanaNativeAdapter---->  onBiddingFailed ----->"+taErrorCode.getErrorMessage());
            super.onBiddingFailed(taErrorCode);
            if(mBiddingListener!=null){
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(taErrorCode.getErrorMessage()));
            }
        }
    };
}
