package com.hisavana.topon.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATBiddingListener;
import com.anythink.core.api.ATBiddingResult;
import com.anythink.splashad.unitgroup.api.CustomSplashAdapter;
import com.cloud.hisavana.sdk.api.adx.TSplashView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.hisavana.topon.cache.AdCache;
import com.hisavana.topon.util.AdapterUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.manager.HisavanaManager;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created  ON 2022/7/26
 *
 * @author :fangxuhui
 */
public class HisavanaSplashAdapter extends CustomSplashAdapter {

    private String unit_id;
    private TSplashView mTSplash;
    private Context context;
    private AtomicBoolean isShowing = new AtomicBoolean(false);
    /**
     * mTSplash的布局
     */
    private ViewGroup container;

    @Override
    public void show(Activity activity, ViewGroup viewGroup) {
        AdapterUtil.logD("HisavanaSplashAdapter ---->show == " + unit_id);
        if (activity != null && !activity.isFinishing() && mTSplash != null && viewGroup != null) {
            if(activity != viewGroup.getContext()){
                return;
            }
            container = viewGroup;
            viewGroup.removeAllViews();
            viewGroup.addView(mTSplash);
            mTSplash.show();
            isShowing.set(true);
        }
    }

    @Override
    public boolean startBiddingRequest(Context context, Map<String, Object> serverExtra, Map<String, Object> localExtra, ATBiddingListener biddingListener) {
        this.context = context;
        mBiddingListener = biddingListener;
        if (serverExtra != null && serverExtra.containsKey(Constants.UNIT_ID)) {
            try {
                unit_id = (String) serverExtra.get(Constants.UNIT_ID);
            } catch (Exception e) {
            }
        }
        if (TextUtils.isEmpty(unit_id)) {
            AdapterUtil.logE("HisavanaSplashAdapter -------> startBiddingRequest----> " + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
        } else {
            AdapterUtil.logD("HisavanaSplashAdapter -------> startBiddingRequest---->  unit_id == " + unit_id);
            loadAd(true);
        }
        return true;
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        this.context = context;
        if (map == null) {
            AdapterUtil.logD("HisavanaSplashAdapter -------> loadCustomNetworkAd ----> map is null or empty ");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.UNIT_ID)) {
            unit_id = (String) map.get(Constants.UNIT_ID);
        } else {
            AdapterUtil.logE("HisavanaSplashAdapter --->loadCustomNetworkAd ------->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
        if (map.containsKey(Constants.PAYLOAD)) {
            Object ad = AdCache.getInstance().getAd(unit_id);
            if (ad != null && ad instanceof TSplashView) {
                AdapterUtil.logD("HisavanaSplashAdapter ---> loadCustomNetworkAd ------->bidding success---> " + ad);
                mTSplash = (TSplashView) ad;
                mTSplash.setListener(listener);
                mTSplash.setSkipListener(skipListener);
                Preconditions.runOnMainThread(new Preconditions.Callback() {
                    @Override
                    public void onRun() {
                        mTSplash.loadAd(AdCache.getInstance().getBiddingInfo(unit_id));
                    }
                });
                return;
            }
        }
        AdapterUtil.logD("HisavanaSplashAdapter --->loadCustomNetworkAd -------> unit_id=" + unit_id);
        loadAd(false);
    }

    @Override
    public void destory() {
        AdapterUtil.logD("HisavanaSplashAdapter ------->  destory  ");
        if (mTSplash != null) {
            mTSplash.destroy();
            mTSplash = null;
        }
        AdCache.getInstance().remove(unit_id);
        dismissCallback();
    }

    @Override
    public String getNetworkPlacementId() {
        return unit_id;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    @Override
    public boolean isAdReady() {
        return mTSplash == null ? false : mTSplash.isReady();
    }

    private void loadAd(boolean isBidding) {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mTSplash == null) {
                    mTSplash = new TSplashView(context, unit_id);
                }
                mTSplash.setListener(listener);
                mTSplash.setSkipListener(skipListener);
                mTSplash.setPlacementId(unit_id);
                if (isBidding) {
                    AdCache.getInstance().putAd(unit_id, mTSplash);
                    mTSplash.retrieveBid();
                } else {
                    mTSplash.loadAd();
                }
            }
        });
    }

    private void dismissCallback() {
        if (isShowing != null && isShowing.get() && mImpressionListener != null) {
            isShowing.set(false);
            mImpressionListener.onSplashAdDismiss();
        }
    }

    /**
     *是否存在这个子viewA,返回true就是有，false就是没有
     */
    private Boolean getChildA(View view) {
        Boolean a = false;
        if (view instanceof ViewGroup) {
            ViewGroup vp = (ViewGroup) view;
            for (int i = 0; i < vp.getChildCount(); i++) {
                View viewchild = vp.getChildAt(i);
                //里面的1000即为需要找View的tag
                if(viewchild.getTag() != null && String.valueOf(viewchild.getTag()).equals("1000")) {
                    return true;
                }
                a = a || getChildA(viewchild);
            }
        }
        return a;
    }

    private AdListener listener = new AdListener() {
        @Override
        public void onAdLoaded() {
            super.onAdLoaded();
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdLoaded ");
            if (mLoadListener != null) {
                mLoadListener.onAdCacheLoaded();
            }
        }

        @Override
        public void onAdClosed() {
            super.onAdClosed();
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdClosed ");
        }

        @Override
        public void onAdShow() {
            super.onAdShow();
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdShow");
            if (mImpressionListener != null) {
                mImpressionListener.onSplashAdShow();
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
            super.onAdClicked(pointBean);
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onAdClicked");
            if (mImpressionListener != null) {
                mImpressionListener.onSplashAdClicked();
                mImpressionListener.onSplashAdDismiss();
            }
        }

        @Override
        public void onError(TaErrorCode adError) {
            super.onError(adError);
            AdapterUtil.logD("HisavanaSplashAdapter ------->  onError--->" + adError.getErrorMessage());
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", adError.getErrorMessage());
            }
        }

        @Override
        public void onTimeOut() {
            super.onTimeOut();
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onTimeOut");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_LOAD_AD_TIMEOUT);
            }
        }

        @Override
        public void onBiddingSuccess(BidInfo bidInfo) {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onBidding");
            if (mBiddingListener == null) {
                return;
            }
            AdCache.getInstance().putBidInfo(unit_id, bidInfo);
            if (bidInfo != null) {
                AdapterUtil.logD("HisavanaSplashAdapter---->   onBidding --->price =" + bidInfo.getPrice());
                mBiddingListener.onC2SBidResult(ATBiddingResult.success(bidInfo.getPrice(), bidInfo.getBiddingToken(), null, ATAdConst.CURRENCY.USD));
            } else {
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(Constants.Error.ERROR_BIDDING_FAILED));
            }
        }

        @Override
        public void onBiddingFailed(@NonNull TaErrorCode taErrorCode) {
            super.onBiddingFailed(taErrorCode);
            AdapterUtil.logD("HisavanaSplashAdapter----> onBiddingFailed ----->" + taErrorCode.getErrorMessage());
            if (mBiddingListener != null) {
                mBiddingListener.onC2SBidResult(ATBiddingResult.fail(taErrorCode.getErrorMessage()));
            }
        }
    };

    private OnSkipListener skipListener = new OnSkipListener() {
        @Override
        public void onClick() {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onClick");
            dismissCallback();
        }

        @Override
        public void onTimeEnd() {
            AdapterUtil.logW("HisavanaSplashAdapter ------->  onTimeEnd");
            dismissCallback();
        }
    };
}
