package com.hisavana.topon.cache;

import com.cloud.hisavana.sdk.data.bean.response.BidInfo;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Created  ON 2022/8/8
 *
 * @author :fangxuhui
 */
public class AdCache {
    private ConcurrentHashMap<String,Object> adMap;
    private ConcurrentHashMap<String,BidInfo> bidInfoMap;

    public static class SingleInstance {
        public static AdCache INSTANCE = new AdCache();
    }

    public static AdCache getInstance() {
        return SingleInstance.INSTANCE;
    }

    public AdCache(){
        adMap = new ConcurrentHashMap(6);
        bidInfoMap = new ConcurrentHashMap(6);
    }

    public void putAd(String key,Object value){
        adMap.put(key,value);
    }
    public void putBidInfo(String key, BidInfo value){
        bidInfoMap.put(key,value);
    }
    public Object getAd(String key){
        Object value = adMap.get(key);
        adMap.remove(key);
        return value;
    }

    public BidInfo getBiddingInfo(String key){
        BidInfo value = bidInfoMap.get(key);
        bidInfoMap.remove(key);
        return value;
    }

    public void remove(String key){
        adMap.remove(key);
        bidInfoMap.remove(key);
    }
}
