package com.hisavana.topon.manager;

import android.content.Context;
import com.anythink.core.api.ATInitMediation;
import com.anythink.core.api.MediationInitCallback;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.hisavana.topon.BuildConfig;
import com.hisavana.topon.Constants;
import com.transsion.ga.AthenaAnalytics;

import java.util.Map;

/**
 * @author fangxuhui
 */
public class HisavanaManager extends ATInitMediation {

    public static void init(Context context, String appId) {
        AdManager.AppId = appId;
        AdxServerConfig.setAppModle(BuildConfig.IS_DEBUG?AdxServerConfig.TEST:AdxServerConfig.RELEASE);
        AdManager.init(context, new AdManager.AdConfigBuilder().setDebug(BuildConfig.IS_DEBUG).testRequest(false)
                .build());
        AthenaAnalytics.setTest(BuildConfig.IS_DEBUG);
    }

    public static String getSdkVersionName() {
        return BuildConfig.VERSION_NAME;
    }

    public static String getNetWorkName() {
        return Constants.NETWORK_NAME;
    }

    @Override
    public void initSDK(Context context, Map<String, Object> map, MediationInitCallback mediationInitCallback) {
//        Log.d(Constants.TAG,"Hisavana init");
//        AdxServerConfig.setAppModle(BuildConfig.DEBUG ? AdxServerConfig.TEST : AdxServerConfig.RELEASE);
//        AdManager.init(new AdManager.AdConfigBuilder().setDebug(BuildConfig.DEBUG).testRequest(BuildConfig.DEBUG)
//                .build());
//        AthenaAnalytics.setTest(BuildConfig.DEBUG);
    }
}