package com.hisavana.topon.util;

import android.util.Log;

import com.hisavana.topon.BuildConfig;

/**
 * @author xinbing.zhang
 * @date :2022/7/26 16:04
 * @description:
 */
public class AdapterUtil {

    private static final String TAG = "hs_top_adapter";

    /**
     * 日志输出控制
     */
    private static final boolean IS_LOGGABLE = Log.isLoggable(TAG, Log.DEBUG);

    private AdapterUtil() {

    }

    /**
     * 当前是否是测试模式
     */
    protected static boolean isDebug() {
        return BuildConfig.IS_DEBUG;
    }

    public static void logD(String msg) {
        if (isDebug() || IS_LOGGABLE) {
            Log.d(TAG, msg);
        }
    }

    public static void logW(String msg) {
        if (isDebug() || IS_LOGGABLE) {
            Log.w(TAG, msg);
        }
    }

    public static void logE(String msg) {
        if (isDebug() || IS_LOGGABLE) {
            Log.e(TAG, msg);
        }
    }
}
