package com.cloud.sdk.commonutil.util;


import android.text.TextUtils;

import com.transsion.core.CoreUtil;
import com.transsion.core.log.ObjectLogUtils;

/**
 * Created by peng.sun by 2017/6/29
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class AdLogUtil {

    public static final String TAG = "ssp";
    // 开屏广告 流程日志
    public static final String SPLASH_TAG = "ssp_splash";
    //View显示监测
    public static final String MEASURE_TAG = "ssp_measure";
    //打底广告流程
    public static final String DEFAULT_TAG = "ssp_default";
    //OKHttp 相关日志
    public static final String IMG_TAG = "ssp_img";
    //302 上报
    public static final String TRACK_TAG = "ssp_track";
    //请求广告流程
    public static final String LOAD_TAG = "ssp_load";
    //二价关键日志
    public static final String SECOND_PRICE_TAG = "ssp_second_price";
    //打印网络加载日志
    public static ObjectLogUtils NET_LOG = new ObjectLogUtils.Builder().setGlobalTag("AD_NET_LOG").setLogHeadSwitch(false).setBorderSwitch(false).create();

    /**
     * 网络请求 输出 url \ response \ error msg
     */
    public static void netLog(String msg) { NET_LOG.i(msg); }

    private final String gloableTag = "ADSDK";
    private final ObjectLogUtils logUtils;
    private final int mLoggingLevel = VERBOSE;
    private static AdLogUtil adLogUtil = null;
    /**
     * 常量
     */
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int WTF = 8;
    public static final int JSON = 9;


    /**
     * 构造函数
     */
    private AdLogUtil() {
        logUtils = new ObjectLogUtils.Builder().setGlobalTag("ADSDK").setLogSwitch(true).setBorderSwitch(false).create();
        logUtils.setInvokeLayer(3);
    }

    public void setLogSwitch(boolean isDebug){
        logUtils.getBuilder().setLogSwitch(isDebug);
    }

    /**
     * 线程安全的单例
     *
     * @return
     */
    public static synchronized AdLogUtil Log() {
        if (adLogUtil == null) {
            synchronized (AdLogUtil.class) {
                if (adLogUtil == null) {
                    adLogUtil = new AdLogUtil();
                }
            }
        }
        return adLogUtil;
    }

    /**
     * 辅助方法 不做修改
     *
     * @param logLevel
     * @return
     */
    private boolean shouldLog(int logLevel) {
        return logLevel >= mLoggingLevel;
    }

    public void log(int logLevel, String tag, String msg) {
        logWithThrowable(logLevel, tag, msg, null);
    }

    /**
     * 真正的显示方法
     *
     * @param logLevel
     * @param tag
     * @param msg
     * @param t
     */
    public void logWithThrowable(int logLevel, String tag, String msg, Throwable t) {
        if (shouldLog(logLevel)) {
            if (!TextUtils.isEmpty(tag)) tag = gloableTag + "__" + tag;
            switch (logLevel) {
                case VERBOSE:
                    if (t != null) {
                        logUtils.v(tag, msg, t);
                    } else {
                        logUtils.v(tag, msg);
                    }
                    break;
                case WARN:
                    if (t != null) {
                        logUtils.w(tag, msg, t);
                    } else {
                        logUtils.w(tag, msg);
                    }
                    break;
                case ERROR:
                    if (t != null) {
                        logUtils.e(tag, msg, t);
                    } else {
                        logUtils.e(tag, msg);
                    }
                    break;
                case DEBUG:
                    if (t != null) {
                        logUtils.d(tag, msg, t);
                    } else {
                        logUtils.d(tag, msg);
                    }
                    break;
                case INFO:
                    if (t != null) {
                        logUtils.i(tag, msg, t);
                    } else {
                        logUtils.i(tag, msg);
                    }
                    break;

                case JSON:
                    logUtils.json(tag, msg);
                    break;

                default:
                    break;
            }
        }
    }

    public void v(String tag, String msg) {
        log(VERBOSE, tag, msg);
    }

    public void v(String tag, String msg, Throwable t) {
        logWithThrowable(VERBOSE, tag, msg, null);
    }

    public void d(String tag, String msg) {
        log(DEBUG, tag, msg);
    }

    public void d(String tag, int id) {
        String msg = CoreUtil.getContext().getString(id);
        log(DEBUG, tag, msg);
    }

    public void d(String tag, String msg, Throwable t) {
        log(DEBUG, tag, msg);
    }

    public void i(String tag, String msg) {
        log(INFO, tag, msg);
    }

    public void i(String tag, String msg, Throwable t) {
        logWithThrowable(INFO, tag, msg, null);
    }

    public void w(String tag, String msg) {
        log(WARN, tag, msg);
    }

    public void w(String tag, String msg, Throwable t) {
        logWithThrowable(WARN, tag, msg, null);
    }

    public void e(String msg) {
        msg = "******" + msg + "******";
        log(ERROR, "", msg);
    }

    public void e(String tag, String msg) {
        msg = "******" + msg + "******";
        log(ERROR, tag, msg);
    }

    public void e(String tag, String msg, Throwable t) {
        msg = "******" + msg + "******";
        logWithThrowable(ERROR, tag, msg, null);
    }

    public void wtf(String tag, String msg) {
        log(WTF, tag, msg);
    }

    public void wtf(String tag, String msg, Throwable t) {
        logWithThrowable(WTF, tag, msg, null);
    }

    public void json(String tag, String msg) {
        logWithThrowable(JSON, tag, msg, null);
    }


}
