package com.cloud.sdk.commonutil.util;

import static android.content.Context.TELEPHONY_SERVICE;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.provider.Settings;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;

import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.log.LogUtils;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.core.utils.EncoderUtil;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 设备相关工具类
 */
public class DeviceUtil {

    /**
     * 安卓id  Md5
     */
    private static String mAndroidIdMd5 = "";
    private static String mAndroidIdMd5ToLowerCase = "";
    private static String mAndroidIdSHA1 = "";
    private static String mGsmLocation = "";

    /**
     * imei
     */
    private static String mImeiMd5 = "";
    private static String mImeiSHA1 = "";

    /**
     * 获取MCC
     *
     * @return 返回MCC
     */
    public static String getMCC() {
        String imsi = DeviceInfo.getIMSI();

        AdLogUtil.Log().d(AdLogUtil.TAG,"imsi is " + imsi);
        // 前三位是mcc，至少需要3位
        if (!TextUtils.isEmpty(imsi) && imsi.length() >= 4) {
            String mcc = imsi.substring(0, 3);
            AdLogUtil.Log().d(AdLogUtil.TAG,"mcc is " + mcc);
            return mcc;
        }
        return "";
    }

    /**
     * 获取mnc
     *
     * @return 返回mnc
     */
    public static String getMNC() {
        String imsi = DeviceInfo.getIMSI();
        AdLogUtil.Log().d(AdLogUtil.TAG,"imsi is " + imsi);
        // 三位之后是MNC,所以要至少4位
        if (!TextUtils.isEmpty(imsi) && imsi.length() >= 4) {
            String mnc = imsi.substring(3);
            AdLogUtil.Log().d(AdLogUtil.TAG,"mnc is " + mnc);
            return mnc;
        }
        return "";
    }

    public static String getCarrier() {
        return DeviceInfo.getIMSI();
    }

    public static String getMachineImeiMD5() {
        if (TextUtils.isEmpty(mImeiMd5)) {
            TelephonyManager manager = (TelephonyManager) CoreUtil.getContext().getApplicationContext().getSystemService(TELEPHONY_SERVICE);
            Class clazz = manager.getClass();
            try {
                Method getImei = clazz.getDeclaredMethod("getImei", int.class);//(int slotId)
                getImei.setAccessible(true);
                mImeiMd5 = (String) getImei.invoke(manager);
            } catch (Exception e) {
                mImeiMd5 = "";
            }
            mImeiMd5 = TextUtils.isEmpty(mImeiMd5) ? "" : EncoderUtil.EncoderByAlgorithm(mImeiMd5, EncoderUtil.ALGORITHM_MD5);

        }
        return mImeiMd5;
    }

    public static String getMachineImeiSha1() {
        if (TextUtils.isEmpty(mImeiSHA1)) {
            TelephonyManager manager = (TelephonyManager) CoreUtil.getContext().getApplicationContext().getSystemService(TELEPHONY_SERVICE);
            Class clazz = manager.getClass();
            try {
                Method getImei = clazz.getDeclaredMethod("getImei", int.class);//(int slotId)
                getImei.setAccessible(true);
                mImeiSHA1 = (String) getImei.invoke(manager);
            } catch (Exception e) {
                mImeiSHA1 = "";
            }
            mImeiSHA1 = TextUtils.isEmpty(mImeiSHA1) ? "" : EncoderUtil.EncoderByAlgorithm(mImeiSHA1, EncoderUtil.ALGORITHM_SHA_1);

        }
        return mImeiSHA1;
    }

    /**
     * 硬件信息拼接出假的唯一ID 去除
     */
    private static String getPseudo_UniqueID() {
        return "35" +
                Build.BOARD.length() % 10 +
                Build.BRAND.length() % 10 +
                Build.CPU_ABI.length() % 10 +
                Build.DEVICE.length() % 10 +
                Build.DISPLAY.length() % 10 +
                Build.HOST.length() % 10 +
                Build.ID.length() % 10 +
                Build.MANUFACTURER.length() % 10 +
                Build.MODEL.length() % 10 +
                Build.PRODUCT.length() % 10 +
                Build.TAGS.length() % 10 +
                Build.TYPE.length() % 10 +
                Build.USER.length() % 10; //13 digits
    }

    /**
     * 获取当前语言和国家
     *
     * @return 返回语言和国家
     */
    public static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    /**
     * 获取所有语言和国家相关信息
     *
     * @return 语言和国家信息
     */
    public static String getLocaleString() {
        Context context = CoreUtil.getContext();
        if (context.getResources() != null && context.getResources().getConfiguration() != null) {
            Locale locale = context.getResources().getConfiguration().locale;
            String localeStr = "";
            localeStr += locale.getCountry() + "|";
            localeStr += locale.getLanguage() + "|";
            localeStr += locale.getDisplayCountry() + "|";
            localeStr += locale.getDisplayLanguage() + "|";
            localeStr += locale.getDisplayName() + "|";
            localeStr += locale.getISO3Country() + "|";
            localeStr += locale.getISO3Language();
            return localeStr;
        }
        return "";
    }


    /**
     * 网卡MAC地址
     *
     * @return
     */
    public static String getLocalMacAddress() {
        String mac = "";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            mac = getMacAddr();
            AdLogUtil.Log().d(AdLogUtil.TAG,"get mac from M+");
        } else {
            WifiManager wifi = (WifiManager) CoreUtil.getContext().getApplicationContext().getSystemService(Context.WIFI_SERVICE);
            if (wifi != null) {
                WifiInfo info = wifi.getConnectionInfo();
                if (info != null) {
                    mac = info.getMacAddress();
                }
            }
            AdLogUtil.Log().d(AdLogUtil.TAG,"normal get mac");
        }
        AdLogUtil.Log().d(AdLogUtil.TAG,"mac is " + mac);
        return mac;
    }


    /**
     * 获取mac地址
     *
     * @return mac地址
     */
    private static String getMacAddr() {
        try {
            List<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")
                        && !nif.getName().equalsIgnoreCase("eth0")) {
                    continue;
                }
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null || macBytes.length == 0) {
                    return "";
                }

                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }

                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        } catch (Throwable e) {
            AdLogUtil.Log().d(AdLogUtil.TAG,"get mac is error: " + e.getMessage());
        }
        return "";
    }

    private static String getProperties(String name, String defValue) {
        String value = defValue;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getDeclaredMethod("get", String.class);
            value = (String) method.invoke(null, name);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return value;
    }

    /**
     * 判断是否为Android Go版本
     */
    public static boolean isGoVersion() {
        try {
            return "1".equals(getProperties("os.go.support", ""))
                    || Build.DISPLAY.toUpperCase().contains("-GO-");
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 获取UUID
     */
    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    /**
     * 获取当前手机系统版本号
     *
     * @return 系统版本号
     */
    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getGmtTimeZone() {
        int timeZone = TimeZone.getDefault().getOffset(System.currentTimeMillis()) / (3600 * 1000);
        AdLogUtil.Log().d(AdLogUtil.TAG,"current time zone is : " + timeZone);
        return String.valueOf(timeZone);
    }

    public static String getAndroidIDMd5() {
        if (!TextUtils.isEmpty(mAndroidIdMd5)) {
            return mAndroidIdMd5;
        } else {
            Context context = CoreUtil.getContext();
            String androidId = Settings.Secure.getString(context.getContentResolver(), "android_id");
            if (!TextUtils.isEmpty(androidId)){
                androidId = androidId.trim();
            }
            mAndroidIdMd5 = TextUtils.isEmpty(androidId) ? "" : EncoderUtil.EncoderByAlgorithm(androidId, EncoderUtil.ALGORITHM_MD5);
            return mAndroidIdMd5;
        }
    }

    /**
     * 小写处理的
     *
     * @return
     */
    public static String getAndroidIDMd5ToLowerCase() {
        if (TextUtils.isEmpty(mAndroidIdMd5ToLowerCase)) {
            Context context = CoreUtil.getContext();
            String androidId = Settings.Secure.getString(context.getContentResolver(), "android_id");
            // 转小写 --> 加密
            if (!TextUtils.isEmpty(androidId)) {
                androidId = androidId.trim();
                androidId.toLowerCase();
            }
            mAndroidIdMd5ToLowerCase = TextUtils.isEmpty(androidId) ? "" : EncoderUtil.EncoderByAlgorithm(androidId, EncoderUtil.ALGORITHM_MD5);
            // 加密之后 --> 继续转小写
            if (!TextUtils.isEmpty(mAndroidIdMd5ToLowerCase)) {
                mAndroidIdMd5ToLowerCase.toLowerCase();
            }
        }
        return mAndroidIdMd5ToLowerCase;
    }


    public static String getAndroidIDSHA1() {
        if (!TextUtils.isEmpty(mAndroidIdSHA1)) {
            return mAndroidIdSHA1;
        } else {
            Context context = CoreUtil.getContext();
            String androidId = Settings.Secure.getString(context.getContentResolver(), "android_id");
            if (!TextUtils.isEmpty(androidId)){
                androidId = androidId.trim();
            }
            mAndroidIdSHA1 = TextUtils.isEmpty(androidId) ? "" : EncoderUtil.EncoderByAlgorithm(androidId, EncoderUtil.ALGORITHM_SHA_1);
            return mAndroidIdSHA1;
        }
    }

    public static boolean checkCanRetryInTimes(String value, AtomicInteger increment, int limit) {
        if (!TextUtils.isEmpty(value)) {
            return false;
        }
        if (increment.getAndIncrement() >= limit) {
            return false;
        }
        AdLogUtil.Log().d("","checkCanRetryInTimes  true ,value =" + value + " limit = " + limit + " increase = " + (increment != null ? increment.get() : 0));
        return true;
    }


    /**
     * 客户端基站信息
     *
     * @return
     */
    private static final AtomicInteger gsmInteger = new AtomicInteger(0);
    public static String getGsmCellLocation() {
        if (!DeviceUtil.checkCanRetryInTimes(mGsmLocation, gsmInteger, 1)) {
            return mGsmLocation;
        }
        try {
            TelephonyManager tel = (TelephonyManager) CoreUtil.getContext().getSystemService(TELEPHONY_SERVICE);
            @SuppressLint("MissingPermission")
            CellLocation cel = tel.getCellLocation();
            if(cel == null){
                return "";
            }
            int cid = 0;
            int lac = 0;
            if (tel.getPhoneType() == TelephonyManager.PHONE_TYPE_CDMA) {//如果是电信卡的话
                CdmaCellLocation cdmaCellLocation = (CdmaCellLocation) cel;
                cid = cdmaCellLocation.getBaseStationId();
                lac = cdmaCellLocation.getNetworkId();
            } else {//如果是移动和联通的话  移动联通一致
                GsmCellLocation gsmCellLocation = (GsmCellLocation) cel;
                if (gsmCellLocation != null) {
                    cid = gsmCellLocation.getCid();
                    lac = gsmCellLocation.getLac();
                }
            }
            return mGsmLocation = cid + "|" + lac;

        } catch (Exception e) {
        }
        return "";
    }

    private static String ip;

    /**
     * 客户端真实ip
     *
     * @return
     */
    public static String getIp() {
        try {
            ConnectivityManager conMann = (ConnectivityManager)
                    CoreUtil.getContext().getApplicationContext().getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mobileNetworkInfo = conMann.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
            NetworkInfo wifiNetworkInfo = conMann.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
            if (mobileNetworkInfo.isConnected()) {
                ip = getLocalIpAddress();
            } else if (wifiNetworkInfo.isConnected()) {
                WifiManager wifiManager = (WifiManager) CoreUtil.getContext().getApplicationContext().getSystemService(Context.WIFI_SERVICE);
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                int ipAddress = wifiInfo.getIpAddress();
                ip = intToIp(ipAddress);
            }
        } catch (Exception ex) {
            AdLogUtil.Log().d(AdLogUtil.TAG,"获取本地ip地址失败 " + ex.getMessage());
        }
        return ip;
    }

    private static boolean isValidIp4Address(final String hostName) {
        try {
            return Inet4Address.getByName(hostName) != null;
        } catch (UnknownHostException ex) {
            AdLogUtil.Log().d(AdLogUtil.TAG,"获取本地ip地址失败 " + ex.getMessage());
            return false;
        }
    }

    private static String getLocalIpAddress() {
        String ipaddress = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface
                    .getNetworkInterfaces();
            // 遍历所用的网络接口
            while (en.hasMoreElements()) {
                NetworkInterface nif = en.nextElement();// 得到每一个网络接口绑定的所有ip
                Enumeration<InetAddress> inet = nif.getInetAddresses();
                // 遍历每一个接口绑定的所有ip
                while (inet.hasMoreElements()) {
                    InetAddress ip = inet.nextElement();
                    if (!ip.isLoopbackAddress()
                            && isValidIp4Address(ip
                            .getHostAddress())) {
                        ipaddress = ip.getHostAddress();
                    }
                }

            }
        } catch (SocketException e) {
            AdLogUtil.Log().d(AdLogUtil.TAG,"获取本地ip地址失败 " + e.getMessage());

        }
        return ipaddress;
    }

    public static String intToIp(int ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFF).append(".");
        sb.append((ipInt >> 8) & 0xFF).append(".");
        sb.append((ipInt >> 16) & 0xFF).append(".");
        sb.append((ipInt >> 24) & 0xFF);
        return sb.toString();
    }


    // =============================================================================================


    /**
     * TODO 一期 先这么弄
     * <p>
     * 全局使用这个
     * Gaid 广告id
     * <p>
     * 先从SP 里面获取 --> 获取到了 --> 直接返回  --> 更新Gaid
     * 没有获取到 -->  DeviceInfo.getGaid
     */
    private static String mGAId = "";

    public static String getGAId() {
        if (mGAId == null || mGAId.length() == 0) {
            // SP 拿结果
            mGAId = AdxPreferencesHelper.getInstance().getString("device_util_ga_id");
            TranssionPoolManager.getInstance().addTask(new Runnable() {
                @Override
                public void run() {
                    try {
                        // AdvertisingIdClient COPY 出来
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(CoreUtil.getContext());
                        // 更新 SP 变更判断
                        if (null != adInfo) {
                            if (!adInfo.getId().equals(mGAId)) {
                                mGAId = adInfo.getId();
                                AdxPreferencesHelper.getInstance().putString("device_util_ga_id", mGAId);
                            }
                            LogUtils.i("gaid is " + mGAId);
                        }

                    } catch (Exception var2) {
                        var2.printStackTrace();
                    }
                }
            });
        }
        return mGAId;
    }

    /**
     * 对称加密之后的 gaid
     */
    public static String getGaidAES(){
        return AESUtils.encrypt(getGAId());
    }


    /**
     *
     */
    private static class AdvertisingIdClient {

        AdvertisingIdClient() {
        }

        static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                throw new IllegalStateException("Cannot be called from the main thread");
            } else {
                try {
                    PackageManager pm = context.getPackageManager();
                    pm.getPackageInfo("com.android.vending", 0);
                } catch (Exception var12) {
                    throw var12;
                }

                AdvertisingConnection connection = new AdvertisingConnection();
                Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
                intent.setPackage("com.google.android.gms");
                if (context.bindService(intent, connection, 1)) {
                    AdInfo var5;
                    try {
                        AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                        AdInfo adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                        var5 = adInfo;
                    } catch (Exception var10) {
                        throw var10;
                    } finally {
                        context.unbindService(connection);
                    }

                    return var5;
                } else {
                    throw new IOException("Google Play connection failed");
                }
            }
        }

        private static final class AdvertisingInterface implements IInterface {
            private final IBinder binder;

            AdvertisingInterface(IBinder pBinder) {
                this.binder = pBinder;
            }

            public IBinder asBinder() {
                return this.binder;
            }

            public String getId() throws RemoteException {
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();

                String id;
                try {
                    data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                    this.binder.transact(1, data, reply, 0);
                    reply.readException();
                    id = reply.readString();
                } finally {
                    reply.recycle();
                    data.recycle();
                }

                return id;
            }

            boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();

                boolean limitAdTracking;
                try {
                    data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                    data.writeInt(paramBoolean ? 1 : 0);
                    this.binder.transact(2, data, reply, 0);
                    reply.readException();
                    limitAdTracking = 0 != reply.readInt();
                } finally {
                    reply.recycle();
                    data.recycle();
                }

                return limitAdTracking;
            }
        }

        private static final class AdvertisingConnection implements ServiceConnection {
            boolean retrieved;
            private final LinkedBlockingQueue<IBinder> queue;

            private AdvertisingConnection() {
                this.retrieved = false;
                this.queue = new LinkedBlockingQueue(1);
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                try {
                    this.queue.put(service);
                } catch (InterruptedException var4) {
                }

            }

            public void onServiceDisconnected(ComponentName name) {
            }

            public IBinder getBinder() throws InterruptedException {
                if (this.retrieved) {
                    throw new IllegalStateException();
                } else {
                    this.retrieved = true;
                    return (IBinder) this.queue.take();
                }
            }
        }

        public static final class AdInfo {
            private final String advertisingId;
            private final boolean limitAdTrackingEnabled;

            AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
                this.advertisingId = advertisingId;
                this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            }

            public String getId() {
                return this.advertisingId;
            }

            public boolean isLimitAdTrackingEnabled() {
                return this.limitAdTrackingEnabled;
            }
        }
    }

}

