package com.cloud.sdk.commonutil.util;
/* Top Secret */

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

import com.transsion.core.CoreUtil;


/**
 * @author wenjing.luo
 * @data 2021/08/05
 * ========================================
 * CopyRight (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class MitNetUtil {
    /**
     * 网络不可用
     */
    private static final int NETWORK_TYPE_UNAVAILABLE = -1;
    /**
     * 以太网
     */
    private static final int NETWORK_TYPE_ETHERNET = 102;
    /**
     * wifi
     */
    private static final int NETWORK_TYPE_WIFI = 103;

    /**
     * Current network is2G
     */
    public static final int NETWORK_CLASS_2_G = 2;
    /**
     * Current network is3G
     */
    public static final int NETWORK_CLASS_3_G = 3;
    /**
     * Current network is4G .
     */
    public static final int NETWORK_CLASS_4_G = 4;
    /**
     * Current network is5G .
     */
    public static final int NETWORK_CLASS_5_G = 5;

    // 适配低版本手机
    /**
     * Network type is unknown
     */
    private static final int NETWORK_TYPE_UNKNOWN = 0;
    /**
     * Current network is GPRS
     */
    private static final int NETWORK_TYPE_GPRS = 1;
    /**
     * Current network is EDGE
     */
    private static final int NETWORK_TYPE_EDGE = 2;
    /**
     * Current network is UMTS
     */
    private static final int NETWORK_TYPE_UMTS = 3;
    /**
     * Current network is CDMA: Either IS95A or IS95B
     */
    private static final int NETWORK_TYPE_CDMA = 4;
    /**
     * Current network is EVDO revision 0
     */
    private static final int NETWORK_TYPE_EVDO_0 = 5;
    /**
     * Current network is EVDO revision A
     */
    private static final int NETWORK_TYPE_EVDO_A = 6;
    /**
     * Current network is 1xRTT
     */
    private static final int NETWORK_TYPE_1xRTT = 7;
    /**
     * Current network is HSDPA
     */
    private static final int NETWORK_TYPE_HSDPA = 8;
    /**
     * Current network is HSUPA
     */
    private static final int NETWORK_TYPE_HSUPA = 9;
    /**
     * Current network is HSPA
     */
    private static final int NETWORK_TYPE_HSPA = 10;
    /**
     * Current network is iDen
     */
    private static final int NETWORK_TYPE_IDEN = 11;
    /**
     * Current network is EVDO revision B
     */
    private static final int NETWORK_TYPE_EVDO_B = 12;
    /**
     * Current network is LTE
     */
    private static final int NETWORK_TYPE_LTE = 13;
    /**
     * Current network is eHRPD
     */
    private static final int NETWORK_TYPE_EHRPD = 14;
    /**
     * Current network is HSPA+
     */
    private static final int NETWORK_TYPE_HSPAP = 15;
    /***
     * Current network is NR(New Radio) 5G.
     */
    private static final int NETWORK_TYPE_NR = 20;


    /**
     * 网络连接类型：0-未知 、1-wifi 、2-2G 、3-3G 、4-4G 、5-5G 、6-ETHERNET
     * ssp需要的网络类型
     */
    public interface net_type {
        int net_type_unavailable = 0;
        int net_type_ethernet = 6;
        int net_type_wifi = 1;
    }

    /**
     * 检查是否有网络。有则返回true
     */
    public static boolean isNetWorkAvailable() {
        if (CoreUtil.getContext().getApplicationContext() == null) {
            return false;
        }
        ConnectivityManager connectMgr = (ConnectivityManager) CoreUtil.getContext().getApplicationContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        if (connectMgr == null) {
            return false;
        }
        NetworkInfo nwInfo = connectMgr.getActiveNetworkInfo();
        return nwInfo != null && nwInfo.isAvailable();
    }


    /**
     * ssp需要的网络类型
     * 0-未知 、1-wifi 、2-2G 、3-3G 、4-4G 、5-5G 、6-ETHERNET
     */
    public static int getNetType() {
        int networkType = getNetworkType();
        switch (networkType) {
            case NETWORK_TYPE_UNKNOWN:
            case NETWORK_TYPE_UNAVAILABLE:
                return net_type.net_type_unavailable;
            case NETWORK_TYPE_ETHERNET:
                return net_type.net_type_ethernet;
            case NETWORK_TYPE_WIFI:
                return net_type.net_type_wifi;
            default:
                return networkType;
        }
    }


    /**
     * ssp需要的网络类型
     *  1、未知  ；2、mobile ；3、wifi
     */
    public static int getWifiOrMobile() {
        int networkType = getNetworkType();
        switch (networkType) {
            case NETWORK_TYPE_UNKNOWN:
            case NETWORK_TYPE_UNAVAILABLE:
                return net_type.net_type_unavailable;
            case NETWORK_TYPE_WIFI:
                return net_type.net_type_wifi;
            default:
                return 2;
        }
    }

    /**
     * 获得网络类型
     * @return
     */
    private static int getNetworkType() {
        int networkType = NETWORK_TYPE_UNKNOWN;
        try {
            if (CoreUtil.getContext().getApplicationContext() == null && CoreUtil.getContext().getApplicationContext().getSystemService(Context.CONNECTIVITY_SERVICE) == null) {
                return NETWORK_TYPE_UNKNOWN;
            }
            final NetworkInfo network = ((ConnectivityManager) CoreUtil.getContext().getApplicationContext()
                    .getSystemService(Context.CONNECTIVITY_SERVICE)).getActiveNetworkInfo();
            if (network != null && network.isAvailable() && network.isConnected()) {
                int type = network.getType();
                if (type == ConnectivityManager.TYPE_WIFI) {
                    networkType = NETWORK_TYPE_WIFI;
                } else if (type == ConnectivityManager.TYPE_MOBILE) {
                    TelephonyManager telephonyManager = (TelephonyManager) CoreUtil.getContext().getApplicationContext()
                            .getSystemService(Context.TELEPHONY_SERVICE);
                    networkType = telephonyManager.getNetworkType();
                }else if (type == ConnectivityManager.TYPE_ETHERNET) {
                    networkType = NETWORK_TYPE_ETHERNET;
                }
            } else {
                networkType = NETWORK_TYPE_UNAVAILABLE;
            }

        } catch (Throwable ex) {
            AdLogUtil.Log().d(AdLogUtil.TAG,"get NetworkType is error: " + ex.getMessage());
        }
        return classifyNetType(networkType);
    }

    /**
     * 归类网络类型
     *
     * @param networkType
     * @return
     */
    private static int classifyNetType(int networkType) {
        switch (networkType) {
            case NETWORK_TYPE_UNAVAILABLE:
                return NETWORK_TYPE_UNAVAILABLE;
            case NETWORK_TYPE_ETHERNET:
                return NETWORK_TYPE_ETHERNET;
            case NETWORK_TYPE_WIFI:
                return NETWORK_TYPE_WIFI;
            case NETWORK_TYPE_GPRS:
            case NETWORK_TYPE_EDGE:
            case NETWORK_TYPE_CDMA:
            case NETWORK_TYPE_1xRTT:
            case NETWORK_TYPE_IDEN:
                return NETWORK_CLASS_2_G;
            case NETWORK_TYPE_UMTS:
            case NETWORK_TYPE_EVDO_0:
            case NETWORK_TYPE_EVDO_A:
            case NETWORK_TYPE_HSDPA:
            case NETWORK_TYPE_HSUPA:
            case NETWORK_TYPE_HSPA:
            case NETWORK_TYPE_EVDO_B:
            case NETWORK_TYPE_EHRPD:
            case NETWORK_TYPE_HSPAP:
                return NETWORK_CLASS_3_G;
            case NETWORK_TYPE_LTE:
                return NETWORK_CLASS_4_G;
            case NETWORK_TYPE_NR:
                return NETWORK_CLASS_5_G;
            default:
                return NETWORK_TYPE_UNKNOWN;
        }
    }
    /**
     * 获取运营商名字
     * @return int
     */
    public static String getOperatorName() {
        if (CoreUtil.getContext().getApplicationContext() != null) {
            TelephonyManager telephonyManager = (TelephonyManager) CoreUtil.getContext().getApplicationContext().getSystemService(Context.TELEPHONY_SERVICE);
            return telephonyManager.getSimOperatorName();
        }
        return "";
    }

}
