package com.cloud.sdk.commonutil.util;
/* Top Secret */

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import java.util.Locale;


/**
 * usage
 *
 * @author peng.sun
 * @data 2017/06/29
 * ========================================
 * CopyRight (c) 2017 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class UserAgentUtil {
    private static String ua = "";

    public static void init() {
        try {
            if (TextUtils.isEmpty(ua)) {
//                ua = WebSettings.getDefaultUserAgent(CoreUtil.getContext());
                ua = getDefaultUserAgent();
                AdLogUtil.Log().d(AdLogUtil.TAG,"ua is not empty");
            }
        } catch (Throwable e) {
            AdLogUtil.Log().e( "init is error , error infor is :=" + Log.getStackTraceString(e));
        }
    }

    /**
     * getUserAgent
     *
     * @return
     */
    public static String getUserAgent() {
        try {
            if (checkAgent()) {
                AdLogUtil.Log().d(AdLogUtil.TAG,"call getUserAgent to get ua ,ua :=" + ua);
                return ua;
            }
            AdLogUtil.Log().d(AdLogUtil.TAG,"ua is empty");
        } catch (Throwable e) {
            AdLogUtil.Log().e( "UserAgentUtil getUserAgent is error , error infor is :=" + Log.getStackTraceString(e));
        }
        return "";
    }

    /**
     * 获取默认UA
     *
     * @return
     */
    private static String getDefaultUserAgent() {
        final String UA = "Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36";
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer();
        // Add version
        final String version = Build.VERSION.RELEASE;
        if (version.length() > 0) {
            buffer.append(version);
        } else {
            // default to "1.0"
            buffer.append("1.0");
        }
        buffer.append("; ");

        final String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language.toLowerCase());
            final String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country.toLowerCase());
            }
        } else {
            // default to "en"
            buffer.append("en");
        }

        // add the model for the release build
        if ("REL".equals(Build.VERSION.CODENAME)) {
            final String model = Build.MODEL;
            if (model.length() > 0) {
                buffer.append("; ");
                buffer.append(model);
            }
        }

        final String id = Build.ID;
        if (id.length() > 0) {
            buffer.append(" Build/");
            buffer.append(id);
        }

        return String.format(UA, buffer);
    }

    /**
     * 检测webview类型
     *
     * @return
     */
    private static boolean checkAgent() {
        try {
            if (TextUtils.isEmpty(ua)) {
                init();
            }
            if (!ua.contains("windows NT") && !ua.contains("Macintosh") && !ua.contains("Dalvik")) {
                return true;
            }
        } catch (Throwable e) {
            AdLogUtil.Log().e( "checkAgent is error , error msg is :=" + Log.getStackTraceString(e));
        }
        return false;
    }
}
