package com.cloud.sdk.commonutil.athena;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;

import com.cloud.sdk.commonutil.BuildConfig;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.GPSTracker;

/**
 * athena上报新开一个线程
 */
public class AthenaUtil {
    private static volatile HandlerThread handlerThread;
    private static final String threadName = "athena track thread";
    private static volatile boolean started = false;
    public static Handler handler;
    private synchronized static void initHandler() {
        if (handler == null) {
            handlerThread = AthenaUtil.getHanderThread();
            AthenaUtil.start();
            handler = new Handler(handlerThread.getLooper());
            //AdLogUtil.Log().d(TAG, "AthenaTracker initHandlerThread");
        }
    }
    /**
     * 上报埋点新开一个子线程
     *
     * @param runnable
     */
    public static void trackInNewThread(final Runnable runnable) {
        initHandler();
        handler.post(runnable);
    }
    public static synchronized HandlerThread getHanderThread() {
        if (handlerThread == null) {
            synchronized (AthenaUtil.class) {
                if (handlerThread == null) {
                    handlerThread = new HandlerThread(threadName);
                }
            }
        }
        return handlerThread;
    }

    public static synchronized void start() {
        if (!started && handlerThread != null) {
            handlerThread.start();
            started = !started;
        }

    }

    public static synchronized void quit() {
        if (handlerThread != null) {
            handlerThread.quit();
        }
    }

    /**
     * @return 获取公参
     */
    public static Bundle getBundle(Bundle bundle) {
        long start = 0;
        if (BuildConfig.DEBUG) {
            start = System.currentTimeMillis();
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putInt("sdk_version_int", PostConstant.getSdkVersionCode());
        bundle.putString("user_agent", PostConstant.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");
        //20220624紧急去除AndroidId
//        bundle.putString("androidId_sha1", PostConstant.getAndroidIdSha1());
//        bundle.putString("androidId_md5", PostConstant.getAndroidIdMd5());

        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());

        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        bundle.putDouble("latitude", GPSTracker.getLatitude());
        bundle.putDouble("longitude", GPSTracker.getLongitude());
        bundle.putLong("coordtime", GPSTracker.getCoordTime());

        bundle.putString("imsi", PostConstant.getMcc());

        if (BuildConfig.DEBUG) {
            CommonLogUtil.Log().d("","AthenaTracker getBundle time = " + (System.currentTimeMillis() - start)+" bundle = "+ bundle);
        }
        return bundle;
    }
}
