package com.cloud.sdk.commonutil.util;

import android.os.Build;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;


import com.cloud.sdk.commonutil.BuildConfig;
import com.cloud.sdk.commonutil.R;

import com.transsion.core.CoreUtil;

import java.security.SecureRandom;
import java.util.Arrays;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * AES 对称加密算法，加解密工具类
 * https://github.com/shaojiankui/AES-Java-iOS-Android
 */
public class AESUtils {
    public final static int GCM_IV_LENGTH = 12;
    public final static int GCM_TAG_LENGTH = 16;
    private static final String CHARSET = "UTF8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static String key = "";

    /**
     * 密钥 sOWGI8LvFnvyH19rs2DytdIIrUOL6ott
     * @return
     */
    private static String garbleSalt() {
        // 第一部分
        if (TextUtils.isEmpty(key)) {
            String s1 = BuildConfig.AES_UTILS_KEY;
            String s2 = get2PartSelfKey(1, 2);
            String s3 = getBK3();
            String s4 = get4String();
            key = s1 + s2 + s3 + s4;
        }
        return key;
    }
    private static String get2PartSelfKey(int x, int y) {

        for (int i = 1; i <= x * y; i++) {
            if (i % x == 0 && i % y == 0)
                return "FnvyH19r";
        }

        return "FnvyH19r";
    }

    private static String getBK3() {
        return "s2DytdII";
    }

    private static String get4String() {
        return CoreUtil.getContext().getResources().getString(R.string.bk4);
    }
    /**
     * AES加密
     *
     * @param privateString 明文
     * @return 密文
     */
    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    public static String encrypt(String privateString) {
        String key = garbleSalt();
        try {
            byte[] raw = key.getBytes();
            byte[] iv = new byte[GCM_IV_LENGTH];
            (new SecureRandom()).nextBytes(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            GCMParameterSpec ivSpec = new GCMParameterSpec(GCM_TAG_LENGTH * Byte.SIZE, iv);
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec, ivSpec);
            byte[] ciphertext = cipher.doFinal(privateString.getBytes(CHARSET));
            byte[] encrypted = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, encrypted, 0, iv.length);
            System.arraycopy(ciphertext, 0, encrypted, iv.length, ciphertext.length);
            return parseByte2HexStr(encrypted);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }

    }

    /**
     * 解密
     * @param encrypted 密文
     * @return 明文
     */
    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    public static String decrypt(String encrypted) {
        String key = garbleSalt();
        try {
            byte[] raw = key.getBytes();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            byte[] decoded = parseHexStr2Byte(encrypted);
            byte[] iv = Arrays.copyOfRange(decoded, 0, GCM_IV_LENGTH);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            GCMParameterSpec ivSpec = new GCMParameterSpec(GCM_TAG_LENGTH * Byte.SIZE, iv);
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, ivSpec);
            byte[] ciphertext = cipher.doFinal(decoded, GCM_IV_LENGTH, decoded.length - GCM_IV_LENGTH);
            return new String(ciphertext, CHARSET);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }

    }


    /**
     * 将Byte数组转换成16进制的字符串
     *
     * @param buf byte[]
     * @return
     */
    public static String parseByte2HexStr(byte[] buf) {
        if (null == buf) {
            return null;
        }

        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * 将16进制字符串转换成byte数组
     *
     * @param hexStr str
     * @return
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }

        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

}
