/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.athena;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.GPSTracker;
import com.transsion.core.CoreUtil;
import com.transsion.ga.AthenaAnalytics;

public class AthenaUtil {
    private static volatile HandlerThread handlerThread;
    private static final String threadName = "athena track thread";
    private static volatile boolean started;
    public static Handler handler;

    private static synchronized void initHandler() {
        if (handler == null) {
            handlerThread = AthenaUtil.getHanderThread();
            AthenaUtil.start();
            handler = new Handler(handlerThread.getLooper());
        }
    }

    public static void trackInNewThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            AthenaUtil.initHandler();
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized HandlerThread getHanderThread() {
        if (handlerThread != null) return handlerThread;
        Class<AthenaUtil> clazz = AthenaUtil.class;
        synchronized (AthenaUtil.class) {
            if (handlerThread != null) return handlerThread;
            handlerThread = new HandlerThread(threadName);
            // ** MonitorExit[var0] (shouldn't be in output)
            return handlerThread;
        }
    }

    public static synchronized void start() {
        if (!started && handlerThread != null) {
            handlerThread.start();
            started = !started;
        }
    }

    public static synchronized void quit() {
        if (handlerThread != null) {
            handlerThread.quit();
        }
    }

    public static Bundle getBundle(Bundle bundle) {
        long start = 0L;
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putInt("sdk_version_int", PostConstant.getSdkVersionCode());
        bundle.putString("user_agent", PostConstant.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");
        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());
        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        bundle.putDouble("latitude", GPSTracker.getLatitude());
        bundle.putDouble("longitude", GPSTracker.getLongitude());
        bundle.putLong("coordtime", GPSTracker.getCoordTime());
        bundle.putString("oneid", AthenaAnalytics.getAppVAID((Context)CoreUtil.getContext()));
        return bundle;
    }

    static {
        started = false;
    }
}

