package com.cloud.sdk.commonutil.gsonutil;

import android.text.TextUtils;
import android.util.Log;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

/**
 * @author xinbing.zhang
 * @date :2021/12/8 3:02 下午
 * @description:
 */
public class DoubleTypeAdapter extends TypeAdapter<Double> {

    @Override
    public Double read(JsonReader in) throws IOException {
        if (null == in) {
            return null;
        }

        switch (in.peek()) {
            case NUMBER:
                return in.nextDouble();
            case STRING:
                String result = in.nextString();
                if (TextUtils.isEmpty(result)) {
                    return null;
                }
                Double d = null;
                try {
                    d = Double.parseDouble(result);
                } catch (Exception e) {
                    Log.getStackTraceString(e);
                }
                return d;
            default:
                in.skipValue();
                return null;
        }
    }

    @Override
    public void write(JsonWriter out, Double value) throws IOException {
        out.value(value);
    }
}