/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.gsonutil;

import android.text.TextUtils;
import android.util.Log;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class DoubleTypeAdapter
extends TypeAdapter<Double> {
    public Double read(JsonReader in) throws IOException {
        if (null == in) {
            return null;
        }
        switch (in.peek()) {
            case NUMBER: {
                return in.nextDouble();
            }
            case STRING: {
                String result = in.nextString();
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return null;
                }
                Double d = null;
                try {
                    d = Double.parseDouble(result);
                }
                catch (Exception e) {
                    Log.getStackTraceString((Throwable)e);
                }
                return d;
            }
        }
        in.skipValue();
        return null;
    }

    public void write(JsonWriter out, Double value) throws IOException {
        out.value((Number)value);
    }
}

