/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.gsonutil;

import android.text.TextUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

public class LongTypeAdapter
extends TypeAdapter<Long> {
    public Long read(JsonReader in) throws IOException {
        if (null == in) {
            return null;
        }
        switch (in.peek()) {
            case NUMBER: {
                try {
                    return in.nextLong();
                }
                catch (NumberFormatException e) {
                    return new BigDecimal(in.nextString()).longValue();
                }
            }
            case STRING: {
                String result = in.nextString();
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return null;
                }
                try {
                    return Long.parseLong(result);
                }
                catch (NumberFormatException e) {
                    return new BigDecimal(result).longValue();
                }
            }
        }
        in.skipValue();
        return null;
    }

    public void write(JsonWriter out, Long value) throws IOException {
        out.value((Number)value);
    }
}

