package com.cloud.sdk.commonutil.control;

import android.os.Handler;
import android.os.HandlerThread;

public class WorkThread {
    private static final String WORK_THREAD_NAME = "h_work_thread";
    private final Handler mWorkHandler;

    private WorkThread() {
        HandlerThread workThread = new HandlerThread(WORK_THREAD_NAME);
        workThread.start();
        mWorkHandler = new Handler(workThread.getLooper());
    }

    public void post(Runnable runnable) {
        if (mWorkHandler != null) {
            mWorkHandler.post(runnable);
        }
    }

    private static class WorkThreadHolder {
        private static final WorkThread INSTANCE = new WorkThread();
    }

    public static WorkThread getInstance() {
        return WorkThreadHolder.INSTANCE;
    }
}
