/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.gsonutil;

import com.cloud.sdk.commonutil.gsonutil.GsonFactory;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public class GsonUtil {
    public static Gson getGson() {
        return GsonFactory.getSingletonGson();
    }

    public static <T> T fromJson(String json, Class<T> classOfT) throws GsonParseException {
        try {
            return (T)GsonUtil.getGson().fromJson(json, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new GsonParseException(e);
        }
    }

    public static <T> T fromJson(String json, Type typeOfT) throws GsonParseException {
        try {
            return (T)GsonUtil.getGson().fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new GsonParseException(e);
        }
    }

    public static String toJson(Object ob) {
        try {
            return GsonUtil.getGson().toJson(ob);
        }
        catch (JsonIOException e) {
            CommonLogUtil.Log().e("GsonUtil", e.getMessage());
            return "";
        }
    }

    public static class GsonParseException
    extends Exception {
        public GsonParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

