/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.gsonutil;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

public class IntegerTypeAdapter
extends TypeAdapter<Integer> {
    public Integer read(JsonReader in) throws IOException {
        if (null == in) {
            return null;
        }
        switch (in.peek()) {
            case NUMBER: {
                try {
                    return in.nextInt();
                }
                catch (NumberFormatException e) {
                    return (int)in.nextDouble();
                }
            }
            case STRING: {
                String result = in.nextString();
                if (result == null || "".equals(result)) {
                    return null;
                }
                try {
                    return Integer.parseInt(result);
                }
                catch (NumberFormatException e) {
                    return (int)new BigDecimal(result).floatValue();
                }
            }
        }
        in.skipValue();
        return null;
    }

    public void write(JsonWriter out, Integer value) throws IOException {
        out.value((Number)value);
    }
}

