/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LifecycleUtil {
    private static final List<WeakReference<Activity>> activityList = new ArrayList<WeakReference<Activity>>();
    private static final List<LifecycleListener> listenerList = new ArrayList<LifecycleListener>();

    public static Activity getMainActivity() {
        if (activityList.isEmpty() || activityList.get(0) == null || activityList.get(0).get() == null) {
            return null;
        }
        return (Activity)activityList.get(0).get();
    }

    public static void addListener(LifecycleListener listener) {
        if (listener != null && !listenerList.contains(listener)) {
            listenerList.add(listener);
        }
    }

    public static void registerActivityLifecycleCallbacks(Application application) {
        if (null == application) {
            return;
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, @Nullable Bundle savedInstanceState) {
                activityList.add(new WeakReference<Activity>(activity));
            }

            public void onActivityStarted(Activity activity) {
                if (!listenerList.isEmpty()) {
                    for (LifecycleListener listener : listenerList) {
                        listener.onActivityStarted(activity);
                    }
                }
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
                if (!listenerList.isEmpty()) {
                    for (LifecycleListener listener : listenerList) {
                        listener.onActivityStopped(activity);
                    }
                }
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                if (listenerList.isEmpty()) {
                    return;
                }
                Iterator iterator = activityList.iterator();
                while (iterator.hasNext()) {
                    WeakReference activityWeakReference = (WeakReference)iterator.next();
                    if (null == activityWeakReference || activityWeakReference.get() != activity) continue;
                    iterator.remove();
                }
            }
        });
    }

    public static abstract class LifecycleListener {
        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }
    }
}

