package com.cloud.sdk.commonutil.athena;

import android.os.Build;
import android.text.TextUtils;

import com.cloud.sdk.commonutil.BuildConfig;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.UserAgentUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.utils.AppUtil;
import com.transsion.core.utils.ScreenUtil;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class PostConstant {
    public static final int TID = 2411;
    public static final String EVENT = "ad_ssp_show";
    public static final String EVENT_IMG = "material_load";
    public static final String EVENT_DEEPLINK = "deeplink";
    public static final String EVENT_AD_SSP_REQUEST = "ad_ssp_request";
    public static final String EVENT_AD_SSP_RETURN = "ad_ssp_return";
    //请求PS素材
    public static final String EVENT_AD_SSP_REQUEST_PS = "ad_ssp_request_ps_material";
    //返回PS素材
    public static final String EVENT_AD_SSP_RETURN_PS = "ad_ssp_return_ps_material";
    //弹窗展现
    public static final String EVENT_AD_PS_POPUP_IMP = "popup_imp";
    //弹窗点击
    public static final String EVENT_AD_PS_POPUP_CLICK = "popup_click";
    //webview重定向
    public static final String EVENT_WEBVIEW_REDIRECT = "ad_web_callback";
    //ssp云控请求
    public static final String EVENT_CLD_REQUEST = "ad_cld_request";
    //ssp云控返回
    public static final String EVENT_CLD_RETURN = "ad_cld_return";
    //form表单离线提交事件
    public static final String EVENT_FORM_INFO_SET = "form_infor_set";
    //点击事件（离线）
    public static final String EVENT_AD_SSP_CLICK= "ad_ssp_click";
    //点击（非加密串）
    public static final String EVENT_SSP_NEW_CLICK= "ssp_new_click";
    //媒体调用请求
    public static final String EVENT_MEDIA_CALL_REQUEST = "media_call_request";
    //填充结果
    public static final String EVENT_AD_FILLING_RESULT = "ad_filling_result";
    //关闭广告
    public static final String EVENT_AD_SSP_CLOSE_AD = "ad_ssp_close_ad";
    // 离线 web 加载完成
    public static final String EVENT_AD_WEB_COMPLETE = "ad_web_complete";
    //2.6.2.0新增触发展现
    public static final String EVENT_AD_TRIGGER_SHOW = "ssp_trigger_show";
    //2.6.2.0新增互动事件
    public static final String EVENT_AD_INTERACTION = "interaction_event";
    //展示过程（插屏互动广告使用）
    public static final String EVENT_SHOW_PROCESS = "show_process";
    private static String sessionId;
    private static String sdkVersion;
    private static int sdkVersionCode;
    private static String userAgent;
    private static int type = -1;
    private static String make;

    private static int screenWidth = -1;
    private static int screenHeight = -1;
    private static int screenDensity = -1;
    private static String mcc;
    private static String mnc;


    private static String brand;
    private static String model;
    private static String osVersion;
    private static int osApiLevel;
    private static String versionName;
    private static String versionCode;


    /**
     * 本次启动唯一ID：每次启动时生成一个唯一批次号，直到下次启动才变更
     */
    public static String getSessionId() {
        if (TextUtils.isEmpty(sessionId)) sessionId = DeviceUtil.getUUID();
        return sessionId;
    }

    /**
     * sdkVersion
     */
    public static String getSdkVersion(){
        if (TextUtils.isEmpty(sdkVersion)){
            sdkVersion= BuildConfig.VERSION_NAME;
        }
        return sdkVersion;
    }

    /**
     * sdkVersionCode
     */
    public static int getSdkVersionCode(){
        if (sdkVersionCode == 0){
            sdkVersionCode= BuildConfig.VERSION_CODE;
        }
        return sdkVersionCode;
    }

    /**
     * 终端用户HTTP请求头中的User-Agent字段
     */
    public static String getUserAgent() {
        if (TextUtils.isEmpty(userAgent)) userAgent = UserAgentUtil.getUserAgent();
        return userAgent;
    }

    /**
     * 设备类型   1=PHONE(手机,含iTouch)
     *          2=TABLET(平板)
     */
    public static int getType() {
        if (type == -1) type = DeviceInfo.isPad() ? 2 : 1;
        return type;
    }

    /**
     * 设备制造商
     */
    public static String getMake() {
        if (TextUtils.isEmpty(make)) make = Build.MANUFACTURER;
        return make;
    }

    /**
     * 安卓idSHA1
     */
//    public static String getAndroidIdSha1(){
//        return DeviceUtil.getAndroidIDSHA1();
//    }

    /**
     * 安卓idMd5
     */
//    public static String getAndroidIdMd5(){
//        return DeviceUtil.getAndroidIDMd5();
//    }


    public static int getScreenWidth() {
        if (screenWidth == -1) screenWidth = ScreenUtil.getWinWidth();
        return screenWidth;
    }

    public static int getScreenHeight() {
        if (screenHeight == -1) screenHeight = ScreenUtil.getWinHeight();
        return screenHeight;
    }

    public static int getScreenDensity() {
        if (screenDensity == -1) screenDensity = (int) ScreenUtil.getDensity();
        return screenDensity;
    }

    private static AtomicInteger mccInteger = new AtomicInteger(0);
    public static String getMcc() {
        if (DeviceUtil.checkCanRetryInTimes(mcc, mccInteger, 1)) {
            String deviceOperator = DeviceInfo.getSimOperator();
            if (!TextUtils.isEmpty(deviceOperator) && deviceOperator.length() >= 3) {
                mcc = deviceOperator.substring(0, 3);
            }
        }
        return mcc;
    }

    private static AtomicInteger mncInteger = new AtomicInteger(0);
    public static String getMnc() {
        if (DeviceUtil.checkCanRetryInTimes(mnc, mncInteger, 1)) {
            String deviceOperator = DeviceInfo.getSimOperator();
            if (!TextUtils.isEmpty(deviceOperator) && deviceOperator.length() >= 3) {
                mnc = deviceOperator.substring(3);
            }
        }
        return mnc;
    }

    public static String getBrand() {
        if (TextUtils.isEmpty(brand)) brand = Build.BRAND;
        return brand;
    }

    public static String getModel() {
        if (TextUtils.isEmpty(model)) model = Build.MODEL;
        return model;
    }

    public static String getOsVersion() {
        if (TextUtils.isEmpty(osVersion)) osVersion = DeviceUtil.getSystemVersion();
        return osVersion;
    }

    public static int getOsApiLevel() {
        if (osApiLevel == 0){
            osApiLevel = DeviceUtil.getOsApiLevel();
        }
        return osApiLevel;
    }

    public static String getVersionName() {
        if (TextUtils.isEmpty(versionName)) versionName = String.valueOf(AppUtil.getVersionName());
        return versionName;
    }

    public static String getVersionCode() {
        if (TextUtils.isEmpty(versionCode)) versionCode = String.valueOf(AppUtil.getVersionCode());
        return versionCode;
    }
}
