/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.cloud.sdk.commonutil.R;

public class TranCircleImageView
extends ImageView {
    private Context context;
    private Paint paint;
    private Paint borderPaint;
    private float radius;
    private float topLeftRadius;
    private float topRightRadius;
    private float bottomLeftRadius;
    private float bottomRightRadius;
    private float topLeftRadius_x;
    private float topLeftRadius_y;
    private float topRightRadius_x;
    private float topRightRadius_y;
    private float bottomLeftRadius_x;
    private float bottomLeftRadius_y;
    private float bottomRightRadius_x;
    private float bottomRightRadius_y;
    private float borderWidth;
    private float borderSpace;
    private int borderColor;
    private boolean circle;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int FITXY = 3;
    private int styleType;

    public TranCircleImageView(Context context) {
        super(context);
        this.initData();
    }

    public TranCircleImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initAttrs(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray ta = this.context.obtainStyledAttributes(attrs, R.styleable.TranCircleImageView);
        this.radius = ta.getDimension(R.styleable.TranCircleImageView_radiusYL, 0.0f);
        this.topLeftRadius = ta.getDimension(R.styleable.TranCircleImageView_topLeftRadiusYL, 0.0f);
        this.topRightRadius = ta.getDimension(R.styleable.TranCircleImageView_topRightRadiusYL, 0.0f);
        this.bottomLeftRadius = ta.getDimension(R.styleable.TranCircleImageView_bottomLeftRadiusYL, 0.0f);
        this.bottomRightRadius = ta.getDimension(R.styleable.TranCircleImageView_bottomRightRadiusYL, 0.0f);
        this.styleType = ta.getInt(R.styleable.TranCircleImageView_scaleTypeYL, 0);
        this.borderWidth = ta.getDimension(R.styleable.TranCircleImageView_borderWidthYL, 0.0f);
        this.borderSpace = ta.getDimension(R.styleable.TranCircleImageView_borderSpaceYL, 0.0f);
        this.borderColor = ta.getColor(R.styleable.TranCircleImageView_borderColorYL, -1);
        this.topLeftRadius_x = ta.getDimension(R.styleable.TranCircleImageView_topLeftRadius_xYL, 0.0f);
        this.topLeftRadius_y = ta.getDimension(R.styleable.TranCircleImageView_topLeftRadius_yYL, 0.0f);
        this.topRightRadius_x = ta.getDimension(R.styleable.TranCircleImageView_topRightRadius_xYL, 0.0f);
        this.topRightRadius_y = ta.getDimension(R.styleable.TranCircleImageView_topRightRadius_yYL, 0.0f);
        this.bottomLeftRadius_x = ta.getDimension(R.styleable.TranCircleImageView_bottomLeftRadius_xYL, 0.0f);
        this.bottomLeftRadius_y = ta.getDimension(R.styleable.TranCircleImageView_bottomLeftRadius_yYL, 0.0f);
        this.bottomRightRadius_x = ta.getDimension(R.styleable.TranCircleImageView_bottomRightRadius_xYL, 0.0f);
        this.bottomRightRadius_y = ta.getDimension(R.styleable.TranCircleImageView_bottomRightRadius_yYL, 0.0f);
        ta.recycle();
        this.initData();
    }

    public void initData() {
        this.initRadius();
        this.circle = this.borderWidth != 0.0f || this.borderSpace != 0.0f || this.topLeftRadius_x != 0.0f || this.topLeftRadius_y != 0.0f || this.topRightRadius_x != 0.0f || this.topRightRadius_y != 0.0f || this.bottomLeftRadius_x != 0.0f || this.bottomLeftRadius_y != 0.0f || this.bottomRightRadius_x != 0.0f || this.bottomRightRadius_y != 0.0f;
        this.paint = new Paint(1);
        this.borderPaint = new Paint(1);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth(this.borderWidth);
        this.borderPaint.setColor(this.borderColor);
        if (this.circle) {
            this.setScaleType(ImageView.ScaleType.MATRIX);
        }
    }

    private void initRadius() {
        if (this.radius != 0.0f) {
            this.topLeftRadius = this.topLeftRadius == 0.0f ? this.radius : this.topLeftRadius;
            this.topRightRadius = this.topRightRadius == 0.0f ? this.radius : this.topRightRadius;
            this.bottomLeftRadius = this.bottomLeftRadius == 0.0f ? this.radius : this.bottomLeftRadius;
            this.bottomRightRadius = this.bottomRightRadius == 0.0f ? this.radius : this.bottomRightRadius;
        }
        this.topLeftRadius_x = this.topLeftRadius_x == 0.0f ? this.topLeftRadius : this.topLeftRadius_x;
        this.topLeftRadius_y = this.topLeftRadius_y == 0.0f ? this.topLeftRadius : this.topLeftRadius_y;
        this.topRightRadius_x = this.topRightRadius_x == 0.0f ? this.topRightRadius : this.topRightRadius_x;
        this.topRightRadius_y = this.topRightRadius_y == 0.0f ? this.topRightRadius : this.topRightRadius_y;
        this.bottomLeftRadius_x = this.bottomLeftRadius_x == 0.0f ? this.bottomLeftRadius : this.bottomLeftRadius_x;
        this.bottomLeftRadius_y = this.bottomLeftRadius_y == 0.0f ? this.bottomLeftRadius : this.bottomLeftRadius_y;
        this.bottomRightRadius_x = this.bottomRightRadius_x == 0.0f ? this.bottomRightRadius : this.bottomRightRadius_x;
        this.bottomRightRadius_y = this.bottomRightRadius_y == 0.0f ? this.bottomRightRadius : this.bottomRightRadius_y;
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        try {
            float i;
            RectF rectF;
            Drawable drawable = this.getDrawable();
            int vw = this.getMeasuredWidth();
            int vh = this.getMeasuredHeight();
            int paddingLeft = this.getPaddingLeft();
            int paddingRight = this.getPaddingRight();
            int paddingTop = this.getPaddingTop();
            int paddingBottom = this.getPaddingBottom();
            if (this.borderWidth != 0.0f) {
                rectF = new RectF((float)paddingLeft, (float)paddingTop, (float)(vw - paddingRight), (float)(vh - paddingBottom));
                i = this.borderWidth / 2.0f;
                rectF.inset(i, i);
                this.drawPath(canvas, rectF, this.borderPaint, i);
            }
            if (this.drawableDisable(drawable) && this.circle) {
                rectF = new RectF((float)paddingLeft, (float)paddingTop, (float)(vw - paddingRight), (float)(vh - paddingBottom));
                i = this.borderWidth + this.borderSpace;
                i = i > 1.0f ? i - 1.0f : 0.0f;
                rectF.inset(i, i);
                int layerId = canvas.saveLayer(rectF, null, 31);
                this.drawPath(canvas, rectF, this.paint, i);
                if (this.paint != null) {
                    this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                }
                Bitmap bitmap = this.drawableToBitmap(drawable);
                Rect src = this.getSrc(bitmap, (int)rectF.width(), (int)rectF.height());
                canvas.drawBitmap(bitmap, src, rectF, this.paint);
                if (this.paint != null) {
                    this.paint.setXfermode(null);
                }
                canvas.restoreToCount(layerId);
            } else {
                super.onDraw(canvas);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Rect getSrc(@NonNull Bitmap bitmap, int rw, int rh) {
        int bw = bitmap.getWidth();
        int bh = bitmap.getHeight();
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        int temp1 = bw * rh;
        int temp2 = rw * bh;
        int[] tempRect = new int[]{bw, bh};
        if (temp1 == temp2) {
            return new Rect(0, 0, bw, bh);
        }
        if (temp1 > temp2) {
            int tempBw;
            tempRect[0] = tempBw = temp2 / rh;
        } else if (temp1 < temp2) {
            int tempBh;
            tempRect[1] = tempBh = temp1 / rw;
        }
        Boolean compare = bw > tempRect[0];
        switch (this.styleType) {
            case 0: {
                left = compare != false ? (bw - tempRect[0]) / 2 : 0;
                top = 0;
                right = compare != false ? (bw + tempRect[0]) / 2 : tempRect[0];
                bottom = tempRect[1];
                break;
            }
            case 1: {
                left = compare != false ? (bw - tempRect[0]) / 2 : 0;
                top = compare != false ? 0 : (bh - tempRect[1]) / 2;
                right = compare != false ? (bw + tempRect[0]) / 2 : tempRect[0];
                bottom = compare != false ? tempRect[1] : (bh + tempRect[1]) / 2;
                break;
            }
            case 2: {
                left = compare != false ? (bw - tempRect[0]) / 2 : 0;
                top = compare != false ? 0 : bh - tempRect[1];
                right = compare != false ? (bw + tempRect[0]) / 2 : tempRect[0];
                bottom = compare != false ? tempRect[1] : bh;
                break;
            }
            case 3: {
                left = 0;
                top = 0;
                right = bw;
                bottom = bh;
                break;
            }
        }
        return new Rect(left, top, right, bottom);
    }

    private void drawPath(Canvas canvas, RectF rectF, Paint paint, float offset) {
        Path path = new Path();
        path.addRoundRect(rectF, new float[]{this.offsetRadius(this.topLeftRadius_x, offset), this.offsetRadius(this.topLeftRadius_y, offset), this.offsetRadius(this.topRightRadius_x, offset), this.offsetRadius(this.topRightRadius_y, offset), this.offsetRadius(this.bottomRightRadius_x, offset), this.offsetRadius(this.bottomRightRadius_y, offset), this.offsetRadius(this.bottomLeftRadius_x, offset), this.offsetRadius(this.bottomLeftRadius_y, offset)}, Path.Direction.CW);
        path.close();
        canvas.drawPath(path, paint);
    }

    private float offsetRadius(float radius, float offset) {
        return Math.max(radius - offset, 0.0f);
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        int w = drawable.getIntrinsicWidth();
        int h = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, w, h);
        drawable.draw(canvas);
        return bitmap;
    }

    private boolean drawableDisable(Drawable drawable) {
        return drawable != null && drawable.getIntrinsicWidth() > 0 && drawable.getIntrinsicHeight() > 0;
    }

    public void setRadius(float radius) {
        this.setTopLeftRadius(radius);
        this.setTopRightRadius(radius);
        this.setBottomLeftRadius(radius);
        this.setBottomRightRadius(radius);
    }

    public void setTopLeftRadius(float topLeftRadius) {
        this.setTopLeftRadius_x(topLeftRadius);
        this.setTopLeftRadius_y(topLeftRadius);
    }

    public void setTopRightRadius(float topRightRadius) {
        this.setTopRightRadius_x(topRightRadius);
        this.setTopRightRadius_y(topRightRadius);
    }

    public void setBottomLeftRadius(float bottomLeftRadius) {
        this.setBottomLeftRadius_x(bottomLeftRadius);
        this.setBottomLeftRadius_y(bottomLeftRadius);
    }

    public void setBottomRightRadius(float bottomRightRadius) {
        this.setBottomRightRadius_x(bottomRightRadius);
        this.setBottomRightRadius_y(bottomRightRadius);
    }

    public void setStyleType(int styleType) {
        this.styleType = styleType;
    }

    public void setCircle(boolean circle) {
        this.circle = circle;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        if (this.borderPaint != null) {
            this.borderPaint.setStrokeWidth(borderWidth);
        }
    }

    public void setBorderSpace(float borderSpace) {
        this.borderSpace = borderSpace;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        if (this.borderPaint != null) {
            this.borderPaint.setColor(borderColor);
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setTopLeftRadius_x(float topLeftRadius_x) {
        this.topLeftRadius_x = topLeftRadius_x;
    }

    public void setTopLeftRadius_y(float topLeftRadius_y) {
        this.topLeftRadius_y = topLeftRadius_y;
    }

    public void setTopRightRadius_x(float topRightRadius_x) {
        this.topRightRadius_x = topRightRadius_x;
    }

    public void setTopRightRadius_y(float topRightRadius_y) {
        this.topRightRadius_y = topRightRadius_y;
    }

    public void setBottomLeftRadius_x(float bottomLeftRadius_x) {
        this.bottomLeftRadius_x = bottomLeftRadius_x;
    }

    public void setBottomLeftRadius_y(float bottomLeftRadius_y) {
        this.bottomLeftRadius_y = bottomLeftRadius_y;
    }

    public void setBottomRightRadius_x(float bottomRightRadius_x) {
        this.bottomRightRadius_x = bottomRightRadius_x;
    }

    public void setBottomRightRadius_y(float bottomRightRadius_y) {
        this.bottomRightRadius_y = bottomRightRadius_y;
    }
}

