package com.cloud.sdk.commonutil.control;

import android.util.Log;

import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.tencent.mmkv.MMKV;
import com.transsion.core.CoreUtil;

import java.util.Set;

public class HisavanaMMKV {
    private static final String TAG = "HisavanaMMKV";
    private MMKV kv;
    private static final HisavanaMMKV INSTANCE = new HisavanaMMKV();

    private HisavanaMMKV() {
        try {
            MMKV.initialize(CoreUtil.getContext());
            kv = MMKV.mmkvWithID("HisavanaMMKV");
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG,"HisavanaMMKV init error "+Log.getStackTraceString(e));
        }
    }

    public static HisavanaMMKV getInstance() {
        return INSTANCE;
    }

    public void clear() {
        try {
            kv.clear();
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "clear " + Log.getStackTraceString(e));
        }
    }

    public void putString(String key, String value) {
        try {
            kv.putString(key, value);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "putString " + Log.getStackTraceString(e));
        }
    }

    public String getString(String key, String defaultValue) {
        try {
            return kv.getString(key, defaultValue);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getString " + Log.getStackTraceString(e));
        }
        return defaultValue;
    }

    public void putInt(String key, int value) {
        try {
            kv.putInt(key, value);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "putInt " + Log.getStackTraceString(e));
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return kv.getInt(key, defaultValue);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getInt " + Log.getStackTraceString(e));
        }
        return defaultValue;
    }

    public void putBoolean(String key, boolean value) {
        try {
            kv.putBoolean(key, value);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "putBoolean " + Log.getStackTraceString(e));
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return kv.getBoolean(key, defaultValue);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getBoolean " + Log.getStackTraceString(e));
        }
        return defaultValue;
    }

    public void putLong(String key, long value) {
        try {
            kv.putLong(key, value);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "putLong " + Log.getStackTraceString(e));
        }
    }

    public long getLong(String key, long defaultValue) {
        try {
            return kv.getLong(key, defaultValue);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getLong " + Log.getStackTraceString(e));
        }
        return defaultValue;
    }

    public Set<String> getStringSet(String key, Set<String> defaultValue) {
        try {
            return kv.getStringSet(key, defaultValue);
        } catch (Exception e) {
            CommonLogUtil.Log().e(TAG, "getStringSet " + Log.getStackTraceString(e));
        }
        return defaultValue;
    }
}
