package com.cloud.sdk.commonutil.util;


import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.transsion.core.CoreUtil;

import java.lang.reflect.Method;

public class HisavanaImageLoader {

    private static boolean isGlide = false;

    /**
     * 初始化glide状态
     */
    public static void initGlideStatus(){
        try {
            if (Class.forName("com.bumptech.glide.Glide") != null){
                isGlide = true;
            }
        } catch(Throwable e){
            CommonLogUtil.Log().e(CommonLogUtil.TAG, "ALL：" + Log.getStackTraceString(e));
        }
    }

    /**
     * 获取glide状态
     * @return
     */
    public static boolean hasGlide() {
        return isGlide;
    }

    /**
     * 展示图片
     * @param url
     * @param imageView
     * @return
     */
    public static boolean loadImage(String url, ImageView imageView){
         try {
            if (TextUtils.isEmpty(url)
                    || imageView == null
                    || !hasGlide()){
                return false;
            }
             Class clazz = Class.forName("com.bumptech.glide.Glide");
             Method method = clazz.getMethod("with", Context.class);
             RequestManager requestManager = (RequestManager) method.invoke(null, CoreUtil.getContext());

             Class requestManagerClaz = requestManager.getClass();
             Method loadMethod = requestManagerClaz.getMethod("load", String.class);
             Object drawableTypeRequest = loadMethod.invoke(requestManager,url);

             Method diskCacheStrategyMethod = drawableTypeRequest.getClass().getMethod("diskCacheStrategy", DiskCacheStrategy.class);
             Object diskCacheStrategyClass  = diskCacheStrategyMethod.invoke(drawableTypeRequest,DiskCacheStrategy.NONE);

             Method intoMethod = diskCacheStrategyClass.getClass().getMethod("into", ImageView.class);
             intoMethod.invoke(drawableTypeRequest,imageView);

        }catch (Throwable e){
            CommonLogUtil.Log().e(CommonLogUtil.TAG, "ALL：" + Log.getStackTraceString(e));
            return false;
        }
        return true;
    }
}
