/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.transsion.core.CoreUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Objects;
import javax.crypto.Cipher;

public class RSAUtils {
    public static final String TAG = "RSAUtils";
    public static final String RSA = "RSA";
    public static final String ECB_PKCS1_PADDING = "RSA/ECB/PKCS1Padding";
    public static final int DEFAULT_KEY_SIZE = 2048;
    public static final byte[] DEFAULT_SPLIT = "#PART#".getBytes();
    public static final int DEFAULT_BUFFERSIZE = 245;
    private static byte[] publicKey = new byte[0];
    public static String PUBLICKEY_ASSETS = "hisavana_rsa_public_key.pem";

    public static byte[] encryptByPublicKey(byte[] data, byte[] publicKey) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        PublicKey keyPublic = kf.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance(ECB_PKCS1_PADDING);
        cipher.init(1, keyPublic);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPrivateKey(byte[] encrypted, byte[] privateKey) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        PrivateKey keyPrivate = kf.generatePrivate(keySpec);
        Cipher cp = Cipher.getInstance(ECB_PKCS1_PADDING);
        cp.init(2, keyPrivate);
        return cp.doFinal(encrypted);
    }

    public static byte[] encryptByPublicKeyForSpilt(byte[] data, byte[] publicKey) throws Exception {
        int dataLen = data.length;
        if (dataLen <= 245) {
            return RSAUtils.encryptByPublicKey(data, publicKey);
        }
        ArrayList<Byte> allBytes = new ArrayList<Byte>(2048);
        int bufIndex = 0;
        int subDataLoop = 0;
        Object buf = new byte[245];
        for (int i = 0; i < dataLen; ++i) {
            Objects.requireNonNull(buf)[bufIndex] = data[i];
            if (++bufIndex != 245 && i != dataLen - 1) continue;
            if (++subDataLoop != 1) {
                for (byte b : DEFAULT_SPLIT) {
                    allBytes.add(b);
                }
            }
            byte[] encryptBytes = RSAUtils.encryptByPublicKey(buf, publicKey);
            for (Object b : (Object)encryptBytes) {
                allBytes.add((byte)b);
            }
            bufIndex = 0;
            buf = i == dataLen - 1 ? null : new byte[Math.min(245, dataLen - i - 1)];
        }
        byte[] bytes = new byte[allBytes.size()];
        int i = 0;
        for (Byte b : allBytes) {
            bytes[i++] = b;
        }
        return bytes;
    }

    public static byte[] decryptByPrivateKeyForSpilt(byte[] encrypted, byte[] privateKey) throws Exception {
        int splitLen = DEFAULT_SPLIT.length;
        if (splitLen <= 0) {
            return RSAUtils.decryptByPrivateKey(encrypted, privateKey);
        }
        int dataLen = encrypted.length;
        ArrayList<Byte> allBytes = new ArrayList<Byte>(1024);
        int latestStartIndex = 0;
        for (int i = 0; i < dataLen; ++i) {
            byte[] decryptPart;
            byte[] part;
            byte bt = encrypted[i];
            boolean isMatchSplit = false;
            if (i == dataLen - 1) {
                part = new byte[dataLen - latestStartIndex];
                System.arraycopy(encrypted, latestStartIndex, part, 0, part.length);
                for (byte b : decryptPart = RSAUtils.decryptByPrivateKey(part, privateKey)) {
                    allBytes.add(b);
                }
                latestStartIndex = i + splitLen;
                i = latestStartIndex - 1;
            } else if (bt == DEFAULT_SPLIT[0]) {
                if (splitLen > 1) {
                    if (i + splitLen < dataLen) {
                        for (int j = 1; j < splitLen && DEFAULT_SPLIT[j] == encrypted[i + j]; ++j) {
                            if (j != splitLen - 1) continue;
                            isMatchSplit = true;
                        }
                    }
                } else {
                    isMatchSplit = true;
                }
            }
            if (!isMatchSplit) continue;
            part = new byte[i - latestStartIndex];
            System.arraycopy(encrypted, latestStartIndex, part, 0, part.length);
            for (byte b : decryptPart = RSAUtils.decryptByPrivateKey(part, privateKey)) {
                allBytes.add(b);
            }
            latestStartIndex = i + splitLen;
            i = latestStartIndex - 1;
        }
        byte[] bytes = new byte[allBytes.size()];
        int i = 0;
        for (Byte b : allBytes) {
            bytes[i++] = b;
        }
        return bytes;
    }

    public static void test() {
        try {
            String publicKeyStr = RSAUtils.getFromAssets("hisavana_rsa_public_key.pem");
            Log.e((String)TAG, (String)("\u516c\u94a5---->" + publicKeyStr));
            byte[] publicKey = Base64.decode((String)publicKeyStr, (int)0);
            String privateKeyStr = RSAUtils.getFromAssets("rsa_private_key.pem");
            Log.e((String)TAG, (String)("\u79c1\u94a5---->" + privateKeyStr));
            byte[] privateKey = Base64.decode((String)privateKeyStr, (int)0);
            String jsonData = "jsonData";
            long start = System.currentTimeMillis();
            byte[] encryptBytes = RSAUtils.encryptByPublicKeyForSpilt(jsonData.getBytes(), publicKey);
            long end = System.currentTimeMillis();
            Log.e((String)TAG, (String)("\u516c\u94a5\u52a0\u5bc6\u8017\u65f6 cost time---->" + (end - start)));
            String encryStr = Base64.encodeToString((byte[])encryptBytes, (int)0);
            Log.e((String)TAG, (String)("\u52a0\u5bc6\u540ejson\u6570\u636e --1-->" + encryStr));
            Log.e((String)TAG, (String)("\u52a0\u5bc6\u540ejson\u6570\u636e\u957f\u5ea6 --1-->" + encryStr.length()));
            start = System.currentTimeMillis();
            byte[] decryptBytes = RSAUtils.decryptByPrivateKeyForSpilt(Base64.decode((String)encryStr, (int)0), privateKey);
            String decryStr = new String(decryptBytes);
            end = System.currentTimeMillis();
            Log.e((String)TAG, (String)("\u79c1\u94a5\u89e3\u5bc6\u8017\u65f6 cost time---->" + (end - start)));
            Log.e((String)TAG, (String)("\u89e3\u5bc6\u540ejson\u6570\u636e --1-->" + decryStr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> encryptByPublicKeyForSpilt(ArrayList<String> arrayList) {
        ArrayList<String> newArrayList = new ArrayList<String>();
        try {
            if (arrayList != null && !arrayList.isEmpty()) {
                for (String s : arrayList) {
                    if (TextUtils.isEmpty((CharSequence)s)) continue;
                    String encryStr = RSAUtils.encryptByPublicKeyForSpilt(s);
                    newArrayList.add(encryStr);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("\u52a0\u5bc6\u5931\u8d25-->" + e.getMessage()));
        }
        return newArrayList;
    }

    public static String encryptByPublicKeyForSpilt(String str) {
        String encryStr = "";
        try {
            if (publicKey.length == 0) {
                String publicKeyStr = RSAUtils.getFromAssets("hisavana_rsa_public_key.pem");
                publicKey = Base64.decode((String)publicKeyStr, (int)0);
            }
            if (!TextUtils.isEmpty((CharSequence)str)) {
                byte[] encryptBytes = RSAUtils.encryptByPublicKeyForSpilt(str.getBytes(), publicKey);
                encryStr = Base64.encodeToString((byte[])encryptBytes, (int)0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("\u52a0\u5bc6\u5931\u8d25-->" + e.getMessage()));
        }
        return encryStr;
    }

    public static void setPublicKey() {
        if (publicKey.length == 0) {
            String publicKeyStr = RSAUtils.getFromAssets(PUBLICKEY_ASSETS);
            publicKey = Base64.decode((String)publicKeyStr, (int)0);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getFromAssets(String fileName) {
        try (InputStreamReader inputReader = new InputStreamReader(CoreUtil.getContext().getResources().getAssets().open(fileName));){
            String string2;
            try (BufferedReader bufReader = new BufferedReader(inputReader);){
                String line;
                StringBuilder Result = new StringBuilder();
                while ((line = bufReader.readLine()) != null) {
                    Result.append(line);
                }
                string2 = Result.toString();
            }
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

