package com.cloud.sdk.commonutil.util;
/* Top Secret */

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;

import com.transsion.core.CoreUtil;


/**
 * @author wenjing.luo
 * @data 2021/08/05
 * ========================================
 * CopyRight (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class MitNetUtil {

    /**
     * 获取运营商名字
     * @return int
     */
    public static String getOperatorName() {
        if (CoreUtil.getContext().getApplicationContext() != null) {
            TelephonyManager telephonyManager = (TelephonyManager) CoreUtil.getContext().getApplicationContext().getSystemService(Context.TELEPHONY_SERVICE);
            return telephonyManager.getSimOperatorName();
        }
        return "";
    }


    // ============================ 同步与Athena判断是否有网络、获取网络类型 =============================


    /**
     * 同步与Athena判断是否有网络
     */
    public static boolean isNetworkAvailable(Context context) {
        if(context == null){
            return false;
        }
        ConnectivityManager cm =
                (ConnectivityManager) context.getApplicationContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm == null) {
            return false;
        }
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                Network activeNetwork = cm.getActiveNetwork();
                if (activeNetwork != null) {
                    NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(activeNetwork);
                    if (networkCapabilities != null) {
                        return networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI)
                                || networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR)
                                || networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_VPN)
                                || networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET);
                    }
                }
            } else {
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                return networkInfo != null && networkInfo.isConnected();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 网络类型枚举
     */
    public enum NetworkType {
        /***0--无网*/
        NETWORK_UNKNOWN,
        /***1--wifi*/
        NETWORK_WIFI,
        /***2--2G*/
        NETWORK_2G,
        /***3--3G */
        NETWORK_3G,
        /***4--4G*/
        NETWORK_4G,
        /***5--5G */
        NETWORK_5G,
        /*** 6--ETHERNET*/
        NETWORK_ETHERNET
    }

    /**
     * 获取当前网络类型
     */
    public static NetworkType getNetworkType(Context context) {
        if (null == context){
            return NetworkType.NETWORK_UNKNOWN;
        }
        ConnectivityManager cm =
                (ConnectivityManager) context.getApplicationContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm == null) {
            return NetworkType.NETWORK_UNKNOWN;
        }
        try {
            NetworkInfo networkInfo = cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
            if (networkInfo != null) {
                NetworkInfo.State state = networkInfo.getState();
                if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING) {
                    return NetworkType.NETWORK_WIFI;
                }
            }
            networkInfo = cm.getNetworkInfo(ConnectivityManager.TYPE_ETHERNET);
            if (networkInfo != null) {
                NetworkInfo.State state = networkInfo.getState();
                if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING) {
                    return NetworkType.NETWORK_ETHERNET;
                }
            }
            networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isAvailable()) {
                if (networkInfo.getType() == ConnectivityManager.TYPE_MOBILE) {
                    switch (networkInfo.getSubtype()) {
                        case TelephonyManager.NETWORK_TYPE_GSM:
                        case TelephonyManager.NETWORK_TYPE_GPRS:
                        case TelephonyManager.NETWORK_TYPE_CDMA:
                        case TelephonyManager.NETWORK_TYPE_EDGE:
                        case TelephonyManager.NETWORK_TYPE_1xRTT:
                        case TelephonyManager.NETWORK_TYPE_IDEN:
                            return NetworkType.NETWORK_2G;

                        case TelephonyManager.NETWORK_TYPE_TD_SCDMA:
                        case TelephonyManager.NETWORK_TYPE_EVDO_A:
                        case TelephonyManager.NETWORK_TYPE_UMTS:
                        case TelephonyManager.NETWORK_TYPE_EVDO_0:
                        case TelephonyManager.NETWORK_TYPE_HSDPA:
                        case TelephonyManager.NETWORK_TYPE_HSUPA:
                        case TelephonyManager.NETWORK_TYPE_HSPA:
                        case TelephonyManager.NETWORK_TYPE_EVDO_B:
                        case TelephonyManager.NETWORK_TYPE_EHRPD:
                        case TelephonyManager.NETWORK_TYPE_HSPAP:
                            return NetworkType.NETWORK_3G;

                        case TelephonyManager.NETWORK_TYPE_IWLAN:
                        case TelephonyManager.NETWORK_TYPE_LTE:
                            return NetworkType.NETWORK_4G;

                        case 20:  // TelephonyManager.NETWORK_TYPE_NR:
                            return NetworkType.NETWORK_5G;
                        default:
                            String subtypeName = networkInfo.getSubtypeName();
                            if (subtypeName.equalsIgnoreCase("TD-SCDMA")
                                    || subtypeName.equalsIgnoreCase("WCDMA")
                                    || subtypeName.equalsIgnoreCase("CDMA2000")) {
                                return NetworkType.NETWORK_3G;
                            } else {
                                return NetworkType.NETWORK_UNKNOWN;
                            }
                    }
                } else {
                    return NetworkType.NETWORK_UNKNOWN;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return NetworkType.NETWORK_UNKNOWN;
    }

}
