package com.cloud.sdk.commonutil.util

import android.os.Handler
import android.os.HandlerThread
import android.os.Looper

/**
 * Created  ON 2024/4/28
 * @author :fangxuhui
 */
object DBWorkThread {
    private const val WORK_THREAD_NAME = "h_db_work_thread"
    private val handlerThread = HandlerThread(WORK_THREAD_NAME).apply { start() }
    private val handler = Handler(handlerThread.looper)
    fun post(runnable: Runnable?) {
        runnable?.let {
            if(Looper.myLooper() == handlerThread.looper){
                it.run()
                return
            }
            handler.post(it)
        }
    }

    fun postDelay(runnable: Runnable?, time: Long) {
       runnable?.let {
           handler.postDelayed(it, time)
       }
    }
}