package com.cloud.sdk.commonutil.util;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;

/**
 * 定时器
 *
 * @author peng.sun
 * @data 2017/7/4
 * ========================================
 * CopyRight (c) 2017 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class RunTimer {
    private static final String TAG = "RunTimer";

    /**
     * 超时回调
     */
    public interface TimeOutCallback {
        /**
         * 超时回调
         */
        void isTimeOut();
    }

    private int scheduleTime = 60 * 1000;

    private TimeOutCallback timeOutCallback;

    private Handler handler;

    /**
     * 执行体
     */
    private Runnable mTimeoutRunnable;


    public void setScheduleTime(int scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public void setTimeOutCallback(TimeOutCallback timeOutCallback) {
        this.timeOutCallback = timeOutCallback;
    }

    /**
     * 启动定时器
     */
    public void runTimerTask() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        if (mTimeoutRunnable == null) {
            mTimeoutRunnable = new Runnable() {
                @Override
                public void run() {
                    if (timeOutCallback != null) {
                        timeOutCallback.isTimeOut();
                    }
                }
            };
        }
        try {
            handler.postDelayed(mTimeoutRunnable, scheduleTime);
        } catch (Throwable e) {
            Log.e(TAG, Log.getStackTraceString(e));
        }
    }


    /**
     * clean
     */
    public void cancelTimeTask() {
        timeOutCallback = null;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
            handler = null;
        }
        mTimeoutRunnable = null;
    }
}
