package com.cloud.sdk.commonutil.util;

import android.util.Log;

import com.transsion.core.CoreUtil;

public class LauncherUtil {

    private static final String TAG = "LauncherUtil";
    private static boolean isLauncherHost = false;
    private static boolean isLauncherHostChecked = false;

    private LauncherUtil() {}

    /**
     * 判断宿主是否是Launcher
     *
     * @return true:是Launcher宿主 false:不是Launcher宿主
     */
    public static boolean isLauncherHost() {
        if (isLauncherHostChecked) {
            return isLauncherHost;
        }
        isLauncherHostChecked = true;
        try {
            String packageName = CoreUtil.getContext().getPackageName();
            if (packageName == null) {
                return isLauncherHost;
            }
            CommonLogUtil.Log().d(TAG, "isLauncherHost: packageName = " + packageName);
            isLauncherHost = packageName.equals("com.transsion.launcher") || packageName.equals("com.transsion.XOSlauncher");
            return isLauncherHost;
        } catch (Exception e) {
            Log.e(TAG, "isLauncherHost: " + Log.getStackTraceString(e));
        }
        return isLauncherHost;
    }
}
