package com.cloud.sdk.commonutil.util

import kotlinx.coroutines.*

object HSScopeHelper {
    /**
     * io操作异常。
     *
     */
    val IO_ERROR = 2

    /**
     * 数据库操作异常。
     *
     */
    val DATABASE_ERROR = 3

    val uiScope = CoroutineScope(Dispatchers.Main)
    val dbScope = CoroutineScope(ThreadUtils.getSinglePool().asCoroutineDispatcher())
    val ioScope = CoroutineScope(Dispatchers.IO)

    @Volatile
    var globalErrorCallBack: IMErrorCallBack? = null
    val dbExceptionHandler = CoroutineExceptionHandler { coroutineContext, exception ->
        if (globalErrorCallBack == null) {
            throw HSException(DATABASE_ERROR, "globalErrorCallBack", exception.cause)
        } else {
            uiScope.launch {
                globalErrorCallBack?.onError(DATABASE_ERROR, exception.message)
            }
        }
    }
    //todo 未来需要放开到多线程
    val ioExceptionHandler = CoroutineExceptionHandler { coroutineContext, exception ->
        if (globalErrorCallBack == null) {
            throw HSException(IO_ERROR, "globalErrorCallBack", exception.cause)
        } else {
            uiScope.launch {
                globalErrorCallBack?.onError(IO_ERROR, exception.message)
            }
        }
    }

    fun runUiJob(runnable: java.lang.Runnable) {
        uiScope.launch {
            runnable.run()
        }
    }

    fun runDbJob(runnable: java.lang.Runnable) {
        dbScope.launch(dbExceptionHandler) {
            runnable.run()
        }
    }

    fun runIoJob(runnable: java.lang.Runnable) {
        ioScope.launch(ioExceptionHandler) {
            runnable.run()
        }
    }

    fun runIoJob(runnable: java.lang.Runnable, delay: Long) {
        ioScope.launch(ioExceptionHandler) {
            delay(delay)
            runnable.run()
        }
    }

    interface IMErrorCallBack {

        /**
         * 发生错误时调用的回调函数，详见 [IMError]。
         *
         * @param code           错误代码。
         * @param error          包含文本类型的错误描述。
         */
        fun onError(code: Int, error: String?)
    }
}