/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;
import java.lang.reflect.Method;

public class HisavanaImageLoader {
    private static final String TAG = "HisavanaImageLoader";
    private static boolean isContainGlide = false;
    private static boolean isUseGlide = true;

    public static void initGlideStatus() {
        try {
            if (Class.forName("com.bumptech.glide.Glide") != null) {
                isContainGlide = true;
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e(TAG, "ALL\uff1a" + Log.getStackTraceString((Throwable)e));
        }
    }

    public static boolean hasGlide() {
        return isContainGlide;
    }

    public static void setUseGlide(boolean useGlide) {
        CommonLogUtil.Log().e(TAG, "set useGlide is " + useGlide);
        isUseGlide = useGlide;
    }

    public static boolean loadImage(String url, ImageView imageView) {
        try {
            if (TextUtils.isEmpty((CharSequence)url) || imageView == null || !HisavanaImageLoader.hasGlide() || !isUseGlide) {
                CommonLogUtil.Log().e(TAG, "Not supporting the use of glide");
                return false;
            }
            CommonLogUtil.Log().e(TAG, "use glide load img");
            Class<?> clazz = Class.forName("com.bumptech.glide.Glide");
            Method method = clazz.getMethod("with", Context.class);
            RequestManager requestManager = (RequestManager)method.invoke(null, CoreUtil.getContext());
            Class<?> requestManagerClaz = requestManager.getClass();
            Method loadMethod = requestManagerClaz.getMethod("load", String.class);
            Object drawableTypeRequest = loadMethod.invoke((Object)requestManager, url);
            Method diskCacheStrategyMethod = drawableTypeRequest.getClass().getMethod("diskCacheStrategy", DiskCacheStrategy.class);
            Object diskCacheStrategyClass = diskCacheStrategyMethod.invoke(drawableTypeRequest, DiskCacheStrategy.NONE);
            Method intoMethod = diskCacheStrategyClass.getClass().getMethod("into", ImageView.class);
            intoMethod.invoke(drawableTypeRequest, imageView);
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e(TAG, "ALL\uff1a" + Log.getStackTraceString((Throwable)e));
            return false;
        }
        return true;
    }

    public static void destroyImageView(ImageView imageView) {
        try {
            if (imageView != null && imageView.getDrawable() != null && !HisavanaImageLoader.hasGlide()) {
                if (imageView.getDrawable() instanceof BitmapDrawable) {
                    Bitmap bitmap;
                    BitmapDrawable drawable = (BitmapDrawable)imageView.getDrawable();
                    if (drawable != null && (bitmap = drawable.getBitmap()) != null && !bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                } else {
                    imageView.setImageDrawable(null);
                }
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w(TAG, Log.getStackTraceString((Throwable)e));
        }
    }
}

