/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class IOUtil {
    private static final String UTF_CODE = "UTF-8";

    private IOUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable ignored) {
                Log.d((String)"error", (String)ignored.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        ByteArrayOutputStream out = null;
        try {
            int len;
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.closeQuietly(out);
        }
    }

    public static byte[] readBytes(InputStream in, long skip, int size) throws IOException {
        byte[] result = null;
        if (skip > 0L) {
            long skipped = 0L;
            while (skip > 0L && (skipped = in.skip(skip)) > 0L) {
                skip -= skipped;
            }
        }
        result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)in.read();
        }
        return result;
    }

    public static String readStr(InputStream in) throws IOException {
        return IOUtil.readStr(in, UTF_CODE);
    }

    public static String readStr(InputStream in, String charset) throws IOException {
        int len;
        if (TextUtils.isEmpty((CharSequence)charset)) {
            charset = UTF_CODE;
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        InputStreamReader reader = new InputStreamReader(in, charset);
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) >= 0) {
            sb.append(buf, 0, len);
        }
        return sb.toString();
    }

    public static void writeStr(OutputStream out, String str) throws IOException {
        IOUtil.writeStr(out, str, UTF_CODE);
    }

    public static void writeStr(OutputStream out, String str, String charset) throws IOException {
        if (TextUtils.isEmpty((CharSequence)charset)) {
            charset = UTF_CODE;
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(str);
        ((Writer)writer).flush();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        if (!(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out);
        }
        int len = 0;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
    }
}

