/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;

public class HisavanaImageLoader {
    private static boolean isGlide = false;

    public static void initGlideStatus() {
        try {
            if (Class.forName("com.bumptech.glide.Glide") != null) {
                isGlide = true;
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e("ssp", "ALL\uff1a" + Log.getStackTraceString((Throwable)e));
        }
    }

    public static boolean hasGlide() {
        return isGlide;
    }

    public static boolean loadImage(String url, ImageView imageView) {
        try {
            if (TextUtils.isEmpty((CharSequence)url) || imageView == null || !HisavanaImageLoader.hasGlide()) {
                return false;
            }
            Glide.with((Context)CoreUtil.getContext()).load(url).into(imageView);
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e("ssp", "ALL\uff1a" + Log.getStackTraceString((Throwable)e));
            return false;
        }
        return true;
    }

    public static void destroyImageView(ImageView imageView) {
        try {
            if (imageView != null && imageView.getDrawable() != null && !HisavanaImageLoader.hasGlide()) {
                if (imageView.getDrawable() instanceof BitmapDrawable) {
                    Bitmap bitmap;
                    BitmapDrawable drawable = (BitmapDrawable)imageView.getDrawable();
                    if (drawable != null && (bitmap = drawable.getBitmap()) != null && !bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                } else {
                    imageView.setImageDrawable(null);
                }
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w("ssp", Log.getStackTraceString((Throwable)e));
        }
    }
}

