/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public class WorkThread {
    private static final String WORK_THREAD_NAME = "h_work_thread";
    private final Handler mWorkHandler;

    private WorkThread() {
        HandlerThread workThread = new HandlerThread(WORK_THREAD_NAME);
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper());
    }

    public void post(Runnable runnable) {
        try {
            if (this.mWorkHandler != null && runnable != null) {
                if (this.mWorkHandler.getLooper().equals(Looper.myLooper())) {
                    runnable.run();
                    return;
                }
                this.mWorkHandler.post(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postDelay(Runnable runnable, long time) {
        if (this.mWorkHandler != null && runnable != null) {
            this.mWorkHandler.postDelayed(runnable, time);
        }
    }

    public Looper getLooper() {
        if (this.mWorkHandler == null) {
            return null;
        }
        return this.mWorkHandler.getLooper();
    }

    public static WorkThread getInstance() {
        return WorkThreadHolder.INSTANCE;
    }

    private static class WorkThreadHolder {
        private static final WorkThread INSTANCE = new WorkThread();

        private WorkThreadHolder() {
        }
    }
}

