/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.control;

import android.text.TextUtils;
import com.cloud.sdk.commonutil.control.HisavanaMMKV;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.utils.SharedPreferencesUtil;
import java.util.HashSet;
import java.util.Set;

public class AdxPreferencesHelper {
    private static final String TAG = "AdxPreferencesHelper";
    private static final String SP_NAME = "hisavana_sdk";
    private static final AdxPreferencesHelper INSTANCE = new AdxPreferencesHelper();
    private HisavanaMMKV hisavanaMMKV;

    private AdxPreferencesHelper() {
        try {
            Class<?> c = Class.forName("com.tencent.mmkv.MMKV");
            if (c == null) {
                CommonLogUtil.Log().e(TAG, "mmkv is not implementation");
                return;
            }
            this.hisavanaMMKV = HisavanaMMKV.getInstance();
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e(TAG, "init mmkv error, com.tencent.mmkv.MMKV not found!");
            this.hisavanaMMKV = null;
        }
    }

    public static AdxPreferencesHelper getInstance() {
        return INSTANCE;
    }

    public void clear() {
        if (this.hisavanaMMKV != null) {
            this.hisavanaMMKV.clear();
        } else {
            SharedPreferencesUtil.getInstance((String)SP_NAME).clear();
        }
    }

    public void putString(String key, String value) {
        if (this.hisavanaMMKV == null) {
            SharedPreferencesUtil.getInstance((String)SP_NAME).putString(key, value);
        } else {
            this.hisavanaMMKV.putString(key, value);
        }
    }

    public String getString(String key, String defaultValue) {
        if (this.hisavanaMMKV != null) {
            return this.hisavanaMMKV.getString(key, defaultValue);
        }
        return SharedPreferencesUtil.getInstance((String)SP_NAME).getString(key, defaultValue);
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public void putInt(String key, int value) {
        if (this.hisavanaMMKV != null) {
            this.hisavanaMMKV.putInt(key, value);
        } else {
            SharedPreferencesUtil.getInstance((String)SP_NAME).putInt(key, value);
        }
    }

    public int getInt(String key, int defaultValue) {
        if (this.hisavanaMMKV != null) {
            return this.hisavanaMMKV.getInt(key, defaultValue);
        }
        return SharedPreferencesUtil.getInstance((String)SP_NAME).getInt(key, defaultValue);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public void putBoolean(String key, boolean value) {
        if (this.hisavanaMMKV != null) {
            this.hisavanaMMKV.putBoolean(key, value);
        } else {
            SharedPreferencesUtil.getInstance((String)SP_NAME).putBoolean(key, value);
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.hisavanaMMKV != null) {
            return this.hisavanaMMKV.getBoolean(key, defaultValue);
        }
        return SharedPreferencesUtil.getInstance((String)SP_NAME).getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public void putLong(String key, long value) {
        if (this.hisavanaMMKV != null) {
            this.hisavanaMMKV.putLong(key, value);
        } else {
            SharedPreferencesUtil.getInstance((String)SP_NAME).putLong(key, value);
        }
    }

    public long getLong(String key, long defaultValue) {
        if (this.hisavanaMMKV != null) {
            return this.hisavanaMMKV.getLong(key, defaultValue);
        }
        return SharedPreferencesUtil.getInstance((String)SP_NAME).getLong(key, defaultValue);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public Set<String> getStringSet(String key, Set<String> defaultValue) {
        if (this.hisavanaMMKV != null) {
            return this.hisavanaMMKV.getStringSet(key, defaultValue);
        }
        return SharedPreferencesUtil.getInstance((String)SP_NAME).getStringSet(key, defaultValue);
    }

    public Set<String> getStringSet(String key) {
        return this.getStringSet(key, new HashSet<String>());
    }

    public void remove(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (this.hisavanaMMKV != null) {
            this.hisavanaMMKV.remove(key);
        } else {
            SharedPreferencesUtil.getInstance((String)SP_NAME).remove(key);
        }
    }
}

