/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.cloud.sdk.commonutil.R;
import com.cloud.sdk.commonutil.util.CoreUtil;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    private static final String TAG = "AESUtils";
    public static final int GCM_IV_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 16;
    private static final String CHARSET = "UTF8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static String key = "";

    private AESUtils() {
    }

    private static String garbleSalt() {
        if (TextUtils.isEmpty((CharSequence)key)) {
            String s1 = "sOWGI8Lv";
            String s2 = AESUtils.get2PartSelfKey(1, 2);
            String s3 = AESUtils.getBK3();
            String s4 = AESUtils.get4String();
            key = s1 + s2 + s3 + s4;
        }
        return key;
    }

    private static String get2PartSelfKey(int x, int y) {
        for (int i = 1; i <= x * y; ++i) {
            if (i % x != 0 || i % y != 0) continue;
            return "FnvyH19r";
        }
        return "FnvyH19r";
    }

    private static String getBK3() {
        return "s2DytdII";
    }

    private static String get4String() {
        return CoreUtil.getContext().getResources().getString(R.string.bk4);
    }

    @RequiresApi(api=19)
    public static String encrypt(String privateString) {
        String key = AESUtils.garbleSalt();
        try {
            byte[] raw = key.getBytes();
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)skeySpec, ivSpec);
            byte[] ciphertext = cipher.doFinal(privateString.getBytes(CHARSET));
            byte[] encrypted = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, encrypted, 0, iv.length);
            System.arraycopy(ciphertext, 0, encrypted, iv.length, ciphertext.length);
            return AESUtils.parseByte2HexStr(encrypted);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    @RequiresApi(api=19)
    public static String decrypt(String encrypted) {
        String key = AESUtils.garbleSalt();
        try {
            byte[] raw = key.getBytes();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            byte[] decoded = AESUtils.parseHexStr2Byte(encrypted);
            if (decoded != null) {
                byte[] iv = Arrays.copyOfRange(decoded, 0, 12);
                Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
                GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
                cipher.init(2, (Key)skeySpec, ivSpec);
                byte[] ciphertext = cipher.doFinal(decoded, 12, decoded.length - 12);
                return new String(ciphertext, CHARSET);
            }
            return "";
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        if (null == buf) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

