/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.AESUtils;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.CoreUtil;
import com.cloud.sdk.commonutil.util.WorkThread;
import com.transsion.sdk.oneid.OneID;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class DeviceUtil {
    private static final String TAG = "DeviceUtil";
    private static String mGsmLocation = "";
    private static String countryCode;
    private static final AtomicInteger gsmInteger;
    private static String ip;
    private static String mGAId;
    private static int isLimitStatus;
    private static final String PREF_GAID = "device_util_ga_id";
    private static final String PREF_IS_LIMIT_AD_TRACKING_ENABLED = "is_limit_ad_tracking_enabled";
    private static final int NOT_GAID = 0;
    private static final int CLOSE_GAID = 1;
    private static final int OPEN_GAID = 2;
    private static long sLastGetGaidTime;

    public static String getOneId() {
        try {
            return OneID.instance().getODID(2411);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    public static String getLocaleString() {
        Context context = CoreUtil.getContext();
        if (context.getResources() != null && context.getResources().getConfiguration() != null) {
            Locale locale = context.getResources().getConfiguration().locale;
            String localeStr = "";
            localeStr = localeStr + locale.getCountry() + "|";
            localeStr = localeStr + locale.getLanguage() + "|";
            localeStr = localeStr + locale.getDisplayCountry() + "|";
            localeStr = localeStr + locale.getDisplayLanguage() + "|";
            localeStr = localeStr + locale.getDisplayName() + "|";
            localeStr = localeStr + locale.getISO3Country() + "|";
            localeStr = localeStr + locale.getISO3Language();
            return localeStr;
        }
        return "";
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE.replace(";", "");
    }

    public static int getOsApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static String getGmtTimeZone() {
        int timeZone = TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 3600000;
        return String.valueOf(timeZone);
    }

    public static boolean checkCanRetryInTimes(String value, AtomicInteger increment, int limit) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return increment.getAndIncrement() < limit;
    }

    public static String getGsmCellLocation() {
        if (!DeviceUtil.checkCanRetryInTimes(mGsmLocation, gsmInteger, 1)) {
            return mGsmLocation;
        }
        try {
            TelephonyManager tel = (TelephonyManager)CoreUtil.getContext().getSystemService("phone");
            CellLocation cel = tel.getCellLocation();
            if (cel == null) {
                return "";
            }
            int cid = 0;
            int lac = 0;
            if (tel.getPhoneType() == 2) {
                CdmaCellLocation cdmaCellLocation = (CdmaCellLocation)cel;
                cid = cdmaCellLocation.getBaseStationId();
                lac = cdmaCellLocation.getNetworkId();
            } else {
                GsmCellLocation gsmCellLocation = (GsmCellLocation)cel;
                if (gsmCellLocation != null) {
                    cid = gsmCellLocation.getCid();
                    lac = gsmCellLocation.getLac();
                }
            }
            mGsmLocation = cid + "|" + lac;
            return mGsmLocation;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getIp() {
        try {
            ConnectivityManager conMann = (ConnectivityManager)CoreUtil.getContext().getApplicationContext().getSystemService("connectivity");
            NetworkInfo mobileNetworkInfo = conMann.getNetworkInfo(0);
            NetworkInfo wifiNetworkInfo = conMann.getNetworkInfo(1);
            if (mobileNetworkInfo.isConnected()) {
                ip = DeviceUtil.getLocalIpAddress();
            } else if (wifiNetworkInfo.isConnected()) {
                WifiManager wifiManager = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                int ipAddress = wifiInfo.getIpAddress();
                ip = DeviceUtil.intToIp(ipAddress);
            }
        }
        catch (Exception ex) {
            CommonLogUtil.Log().d("ssp", "\u83b7\u53d6\u672c\u5730ip\u5730\u5740\u5931\u8d25 " + ex.getMessage());
        }
        return ip;
    }

    private static boolean isValidIp4Address(String hostName) {
        try {
            return Inet4Address.getByName(hostName) != null;
        }
        catch (UnknownHostException ex) {
            CommonLogUtil.Log().d("ssp", "\u83b7\u53d6\u672c\u5730ip\u5730\u5740\u5931\u8d25 " + ex.getMessage());
            return false;
        }
    }

    private static String getLocalIpAddress() {
        String ipaddress = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface nif = en.nextElement();
                Enumeration<InetAddress> inet = nif.getInetAddresses();
                while (inet.hasMoreElements()) {
                    InetAddress ip = inet.nextElement();
                    if (ip.isLoopbackAddress() || !DeviceUtil.isValidIp4Address(ip.getHostAddress())) continue;
                    ipaddress = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            CommonLogUtil.Log().d("ssp", "\u83b7\u53d6\u672c\u5730ip\u5730\u5740\u5931\u8d25 " + e.getMessage());
        }
        return ipaddress;
    }

    public static String intToIp(int ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFF).append(".");
        sb.append(ipInt >> 8 & 0xFF).append(".");
        sb.append(ipInt >> 16 & 0xFF).append(".");
        sb.append(ipInt >> 24 & 0xFF);
        return sb.toString();
    }

    public static int getGaidStatus() {
        if (isLimitStatus == 0) {
            isLimitStatus = AdxPreferencesHelper.getInstance().getInt(PREF_IS_LIMIT_AD_TRACKING_ENABLED, 0);
        }
        return isLimitStatus;
    }

    public static String getGAId() {
        if (TextUtils.isEmpty((CharSequence)mGAId)) {
            long now = System.currentTimeMillis();
            if (now - sLastGetGaidTime < 10000L) {
                return mGAId;
            }
            sLastGetGaidTime = now;
            mGAId = AdxPreferencesHelper.getInstance().getString(PREF_GAID);
            if (Looper.myLooper() == Looper.getMainLooper()) {
                WorkThread.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        DeviceUtil.queryGaid();
                    }
                });
            } else {
                DeviceUtil.queryGaid();
            }
        }
        return mGAId;
    }

    private static void queryGaid() {
        try {
            AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(CoreUtil.getContext());
            if (null != adInfo && !adInfo.getId().equals(mGAId)) {
                mGAId = adInfo.getId();
                boolean isAdLimit = adInfo.isLimitAdTrackingEnabled();
                AdxPreferencesHelper.getInstance().putString(PREF_GAID, mGAId);
                AdxPreferencesHelper.getInstance().putInt(PREF_IS_LIMIT_AD_TRACKING_ENABLED, isAdLimit ? 1 : 2);
                CommonLogUtil.Log().i("ssp", "gaid limit \uff1a" + isAdLimit + " GAID is \uff1a" + mGAId);
            }
        }
        catch (Exception var2) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)var2));
        }
    }

    public static String getGaidAES() {
        return AESUtils.encrypt(DeviceUtil.getGAId());
    }

    public static String getCPU() {
        String[] stringArray;
        if (Build.VERSION.SDK_INT >= 21) {
            stringArray = Build.SUPPORTED_ABIS;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = Build.CPU_ABI;
            stringArray = stringArray2;
            stringArray2[1] = Build.CPU_ABI2;
        }
        String[] abis = stringArray;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < abis.length; ++i) {
            builder.append(abis[i]);
            if (i >= abis.length - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static String getCountryCode() {
        try {
            if (!TextUtils.isEmpty((CharSequence)countryCode)) {
                return countryCode;
            }
            TelephonyManager manager = (TelephonyManager)CoreUtil.getContext().getSystemService("phone");
            String simCountry = manager.getSimCountryIso();
            if (!TextUtils.isEmpty((CharSequence)simCountry)) {
                String sSimCardCountryCode;
                countryCode = sSimCardCountryCode = simCountry.toUpperCase();
                return sSimCardCountryCode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static long getTotalMemory() {
        try {
            ActivityManager am = (ActivityManager)CoreUtil.getContext().getSystemService("activity");
            ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
            am.getMemoryInfo(mi);
            return mi.totalMem;
        }
        catch (Exception e) {
            CommonLogUtil.Log().d("ssp", "\u83b7\u53d6\u672c\u5730\u8fd0\u884c\u5185\u5b58\u5931\u8d25 " + e.getMessage());
            return 0L;
        }
    }

    static {
        gsmInteger = new AtomicInteger(0);
        mGAId = "";
        isLimitStatus = 0;
        sLastGetGaidTime = 0L;
    }

    private static class AdvertisingIdClient {
        AdvertisingIdClient() {
        }

        static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                throw new IllegalStateException("Cannot be called from the main thread");
            }
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
            AdvertisingConnection connection = new AdvertisingConnection();
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            if (context.bindService(intent, (ServiceConnection)connection, 1)) {
                AdInfo var5;
                try {
                    AdInfo adInfo;
                    AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                    var5 = adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                }
                catch (Exception var10) {
                    throw var10;
                }
                finally {
                    context.unbindService((ServiceConnection)connection);
                }
                return var5;
            }
            throw new IOException("Google Play connection failed");
        }

        public static final class AdInfo {
            private final String advertisingId;
            private final boolean limitAdTrackingEnabled;

            AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
                this.advertisingId = advertisingId;
                this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            }

            public String getId() {
                return this.advertisingId;
            }

            public boolean isLimitAdTrackingEnabled() {
                return this.limitAdTrackingEnabled;
            }
        }

        private static final class AdvertisingConnection
        implements ServiceConnection {
            boolean retrieved = false;
            private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

            private AdvertisingConnection() {
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                try {
                    this.queue.put(service);
                }
                catch (Exception var4) {
                    CommonLogUtil.Log().e(Log.getStackTraceString((Throwable)var4));
                }
            }

            public void onServiceDisconnected(ComponentName name) {
            }

            public IBinder getBinder() throws InterruptedException {
                if (this.retrieved) {
                    throw new IllegalStateException();
                }
                this.retrieved = true;
                return this.queue.take();
            }
        }

        private static final class AdvertisingInterface
        implements IInterface {
            private final IBinder binder;

            AdvertisingInterface(IBinder pBinder) {
                this.binder = pBinder;
            }

            public IBinder asBinder() {
                return this.binder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getId() throws RemoteException {
                String id;
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                    this.binder.transact(1, data, reply, 0);
                    reply.readException();
                    id = reply.readString();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
                return id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
                boolean limitAdTracking;
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                    data.writeInt(paramBoolean ? 1 : 0);
                    this.binder.transact(2, data, reply, 0);
                    reply.readException();
                    limitAdTracking = 0 != reply.readInt();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
                return limitAdTracking;
            }
        }
    }
}

