/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.cloud.sdk.commonutil.util.CoreUtil;
import java.lang.reflect.Method;

public class ScreenUtil {
    private static DisplayMetrics getDisplayMetrics() {
        if (CoreUtil.getContext() == null) {
            return null;
        }
        WindowManager windowManager = (WindowManager)CoreUtil.getContext().getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> cls = Class.forName("android.view.Display");
            Method method = cls.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, dm);
            return dm;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }

    public static int getWinWidth() {
        if (CoreUtil.getContext() == null) {
            return -1;
        }
        DisplayMetrics dm = ScreenUtil.getDisplayMetrics();
        return dm.widthPixels;
    }

    public static int getWinHeight() {
        if (CoreUtil.getContext() == null) {
            return -1;
        }
        DisplayMetrics dm = ScreenUtil.getDisplayMetrics();
        return dm.heightPixels;
    }

    public static int getScreenOrientation() {
        if (CoreUtil.getContext() == null || CoreUtil.getContext().getResources() == null) {
            return 0;
        }
        Configuration mConfiguration = CoreUtil.getContext().getResources().getConfiguration();
        return mConfiguration.orientation;
    }

    public static int getDensityDpi() {
        DisplayMetrics dm = ScreenUtil.getDisplayMetrics();
        return dm == null ? -1 : dm.densityDpi;
    }

    public static float getDensity() {
        DisplayMetrics dm = ScreenUtil.getDisplayMetrics();
        return dm == null ? -1.0f : dm.density;
    }

    public static float getDensityScale() {
        DisplayMetrics dm = ScreenUtil.getDisplayMetrics();
        return dm == null ? -1.0f : dm.scaledDensity;
    }

    public static int dip2px(float dpValue) {
        float scale = ScreenUtil.getDensity();
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(float pxValue) {
        float scale = ScreenUtil.getDensity();
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(float spValue) {
        float fontScale = ScreenUtil.getDensityScale();
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(float pxValue) {
        float fontScale = ScreenUtil.getDensityScale();
        return (int)(pxValue / fontScale + 0.5f);
    }
}

