/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import com.cloud.sdk.commonutil.util.CoreUtil;
import java.lang.reflect.Field;

@SuppressLint(value={"SoonBlockedPrivateApi"})
public class ToastUtil {
    private static Handler mHandler = new Handler(Looper.getMainLooper());
    private static Toast toast = null;
    private static Field sField_TN;
    private static Field sField_TN_Handler;

    public static void showToast(final int resId) {
        final Context context = CoreUtil.getContext();
        if (resId > 0) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (toast != null) {
                        toast.setText(resId);
                        toast.setDuration(0);
                        ToastUtil.hook(toast);
                    } else {
                        toast = Toast.makeText((Context)context.getApplicationContext(), (int)resId, (int)0);
                    }
                    toast.show();
                }
            });
        }
    }

    public static void showToast(final String text) {
        final Context context = CoreUtil.getContext();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (toast != null) {
                        toast.setText((CharSequence)text);
                        toast.setDuration(0);
                        ToastUtil.hook(toast);
                    } else {
                        toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)0);
                    }
                    toast.show();
                }
            });
        }
    }

    public static void showLongToast(final int resId) {
        final Context context = CoreUtil.getContext();
        if (resId > 0) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (toast != null) {
                        toast.setText(resId);
                        toast.setDuration(1);
                        ToastUtil.hook(toast);
                    } else {
                        toast = Toast.makeText((Context)context.getApplicationContext(), (int)resId, (int)1);
                    }
                    toast.show();
                }
            });
        }
    }

    public static void showLongToast(final String text) {
        final Context context = CoreUtil.getContext();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (toast != null) {
                        toast.setText((CharSequence)text);
                        toast.setDuration(1);
                        ToastUtil.hook(toast);
                    } else {
                        toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)1);
                    }
                    toast.show();
                }
            });
        }
    }

    private static void hook(Toast toast) {
        try {
            Object tn = sField_TN.get(toast);
            Handler preHandler = (Handler)sField_TN_Handler.get(tn);
            if (preHandler != null && !(preHandler instanceof SafelyHandlerWrapper)) {
                sField_TN_Handler.set(tn, (Object)new SafelyHandlerWrapper(preHandler));
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
    }

    static {
        try {
            sField_TN = Toast.class.getDeclaredField("mTN");
            sField_TN.setAccessible(true);
            sField_TN_Handler = sField_TN.getType().getDeclaredField("mHandler");
            sField_TN_Handler.setAccessible(true);
        }
        catch (Exception var1) {
            var1.printStackTrace();
        }
    }

    private static class SafelyHandlerWrapper
    extends Handler {
        private Handler impl;

        SafelyHandlerWrapper(Handler impl) {
            this.impl = impl;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception var3) {
                var3.printStackTrace();
            }
        }

        public void handleMessage(Message msg) {
            this.impl.handleMessage(msg);
        }
    }
}

