/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.pool;

import android.os.Process;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.FilenameFilter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class HSPoolExecutor
extends ThreadPoolExecutor {
    public static final String DEFAULT_SOURCE_EXECUTOR_NAME = "source";
    public static final String TRANSSION_EXECUTOR_NAME = "zero";
    public static final String DEFAULT_DISK_CACHE_EXECUTOR_NAME = "disk-cache";
    public static final int DEFAULT_DISK_CACHE_EXECUTOR_THREADS = 1;
    private static final String TAG = "ZeroPoolExecutor";
    private static final String CPU_NAME_REGEX = "cpu[0-9]+";
    private static final String CPU_LOCATION = "/sys/devices/system/cpu/";
    private static final int MAXIMUM_AUTOMATIC_THREAD_COUNT = 4;
    private final boolean executeSynchronously;

    public static HSPoolExecutor newDiskCacheExecutor() {
        return HSPoolExecutor.newDiskCacheExecutor(1, DEFAULT_DISK_CACHE_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT);
    }

    public static HSPoolExecutor newDiskCacheExecutor(int threadCount, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return new HSPoolExecutor(threadCount, name, uncaughtThrowableStrategy, true, false);
    }

    public static HSPoolExecutor newSourceExecutor() {
        return HSPoolExecutor.newSourceExecutor(HSPoolExecutor.calculateBestThreadCount(), DEFAULT_SOURCE_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT);
    }

    public static HSPoolExecutor newSourceExecutor(int threadCount, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return new HSPoolExecutor(threadCount, name, uncaughtThrowableStrategy, false, false);
    }

    public static HSPoolExecutor newTranssionExecutor() {
        return new HSPoolExecutor(20, TRANSSION_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT, false, false);
    }

    public static HSPoolExecutor newTranssionExecutor(int maxPoolSize) {
        if (maxPoolSize <= 0) {
            maxPoolSize = 20;
        }
        return new HSPoolExecutor(maxPoolSize, TRANSSION_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT, false, false);
    }

    public HSPoolExecutor(int maxPoolSize, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean preventNetworkOperations, boolean executeSynchronously) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(name, uncaughtThrowableStrategy, preventNetworkOperations));
        this.executeSynchronously = executeSynchronously;
        try {
            Log.d((String)"ThreadPool", (String)("size is :" + this.getPoolSize()));
        }
        catch (Exception var7) {
            var7.printStackTrace();
        }
    }

    @Override
    public void execute(Runnable command) {
        if (this.executeSynchronously) {
            command.run();
        } else {
            super.execute(command);
        }
    }

    @Override
    @NonNull
    public Future<?> submit(Runnable task) {
        return this.maybeWait(super.submit(task));
    }

    private <T> Future<T> maybeWait(Future<T> future) {
        if (this.executeSynchronously) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException var3) {
                throw new RuntimeException(var3);
            }
        }
        return future;
    }

    @Override
    @NonNull
    public <T> Future<T> submit(Runnable task, T result) {
        return this.maybeWait(super.submit(task, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.maybeWait(super.submit(task));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ComparableFutureTask<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ComparableFutureTask<T>(callable);
    }

    public static int calculateBestThreadCount() {
        File[] cpus = null;
        try {
            File cpuInfo = new File(CPU_LOCATION);
            final Pattern cpuNamePattern = Pattern.compile(CPU_NAME_REGEX);
            cpus = cpuInfo.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return cpuNamePattern.matcher(s).matches();
                }
            });
        }
        catch (Throwable var3) {
            Log.d((String)TAG, (String)"Failed to calculate accurate cpu count");
        }
        int cpuCount = cpus != null ? cpus.length : 0;
        int availableProcessors = Math.max(1, Runtime.getRuntime().availableProcessors());
        return Math.min(4, Math.max(availableProcessors, cpuCount));
    }

    protected class ComparableFutureTask<V>
    extends FutureTask<V>
    implements Comparable<ComparableFutureTask<V>> {
        private Object object;

        public ComparableFutureTask(Callable<V> callable) {
            super(callable);
            this.object = callable;
        }

        public ComparableFutureTask(Runnable runnable, V result) {
            super(runnable, result);
            this.object = runnable;
        }

        @Override
        public int compareTo(ComparableFutureTask<V> o) {
            if (this == o) {
                return 0;
            }
            if (o == null) {
                return -1;
            }
            return this.object != null && o.object != null && this.object.getClass().equals(o.object.getClass()) && this.object instanceof Comparable ? ((Comparable)this.object).compareTo(o.object) : 0;
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                Log.d((String)HSPoolExecutor.TAG, (String)"Request threw uncaught throwable");
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                if (t != null) {
                    throw new RuntimeException("Request threw uncaught throwable", t);
                }
            }
        };

        public static final UncaughtThrowableStrategy DEFAULT;

        protected void handle(Throwable t) {
        }

        static {
            DEFAULT = LOG;
        }
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final String name;
        private final UncaughtThrowableStrategy uncaughtThrowableStrategy;
        private final boolean preventNetworkOperations;
        private int threadNum;

        DefaultThreadFactory(String name, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean preventNetworkOperations) {
            this.name = name;
            this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
            this.preventNetworkOperations = preventNetworkOperations;
        }

        @Override
        public synchronized Thread newThread(@NonNull Runnable runnable) {
            Thread result = new Thread(runnable, "zero-" + this.name + "-thread-" + this.threadNum){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    if (preventNetworkOperations) {
                        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectNetwork().penaltyDeath().build());
                    }
                    try {
                        super.run();
                    }
                    catch (Throwable var2) {
                        uncaughtThrowableStrategy.handle(var2);
                    }
                }
            };
            ++this.threadNum;
            return result;
        }
    }
}

