/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.HSCoreUtil;

public class HisavanaImageLoader {
    private static final String TAG = "HisavanaImageLoader";
    private static boolean isContainGlide = false;
    private static boolean isUseGlide = true;

    public static void initGlideStatus() {
        try {
            if (Class.forName("com.bumptech.glide.Glide") != null) {
                isContainGlide = true;
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().e("ssp", "init glide error, com.bumptech.glide.Glide not found!");
        }
    }

    public static boolean hasGlide() {
        return isContainGlide;
    }

    public static void setUseGlide(boolean useGlide) {
        isUseGlide = useGlide;
    }

    public static boolean loadImageWithGlide(String url, ImageView imageView, boolean highPriority) {
        try {
            if (TextUtils.isEmpty((CharSequence)url) || imageView == null || !HisavanaImageLoader.hasGlide() || !isUseGlide) {
                return false;
            }
            RequestOptions options = (RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE);
            if (highPriority) {
                options = (RequestOptions)((RequestOptions)options.useUnlimitedSourceGeneratorsPool(true)).priority(Priority.IMMEDIATE);
            }
            Glide.with((Context)HSCoreUtil.getContext()).load(url).apply((BaseRequestOptions)options).into(imageView);
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w(TAG, "Glide\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    public static void destroyImageView(ImageView imageView) {
        try {
            if (imageView != null && imageView.getDrawable() != null && !HisavanaImageLoader.hasGlide()) {
                if (imageView.getDrawable() instanceof BitmapDrawable) {
                    Bitmap bitmap;
                    BitmapDrawable drawable = (BitmapDrawable)imageView.getDrawable();
                    if (drawable != null && (bitmap = drawable.getBitmap()) != null && !bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                } else {
                    imageView.setImageDrawable(null);
                }
            }
        }
        catch (Throwable e) {
            CommonLogUtil.Log().w(TAG, Log.getStackTraceString((Throwable)e));
        }
    }
}

