/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.gsonutil;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class StringTypeAdapter
extends TypeAdapter<String> {
    public String read(JsonReader in) throws IOException {
        if (null == in) {
            return null;
        }
        switch (in.peek()) {
            case STRING: 
            case NUMBER: {
                return in.nextString();
            }
            case BOOLEAN: {
                return Boolean.toString(in.nextBoolean());
            }
            case BEGIN_OBJECT: {
                return StringTypeAdapter.parseToJson(in);
            }
        }
        in.skipValue();
        return null;
    }

    private static String parseToJson(JsonReader in) {
        try {
            return new Gson().toJson(JsonParser.parseReader((JsonReader)in));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void write(JsonWriter out, String value) throws IOException {
        out.value(value);
    }
}

