/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.complicance;

import android.content.Context;
import android.util.Log;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class ComplianceHelper {
    private static final String SP_KEY = "complianceEnabled";
    private static final AtomicBoolean complianceEnabledCache = new AtomicBoolean(true);

    private ComplianceHelper() {
    }

    private static void bindApplication(Context context) {
        HSCoreUtil.setContext(context);
    }

    public static void initialize(Context context) {
        ComplianceHelper.bindApplication(context);
        boolean enabled = false;
        try {
            enabled = AdxPreferencesHelper.getInstance().getBoolean(SP_KEY, true);
        }
        catch (Exception e) {
            Log.e((String)"ComplianceHelper", (String)("initialize error" + e.getMessage()));
        }
        complianceEnabledCache.set(enabled);
    }

    public static void setGdprComplianceEnabled(Context context, boolean enabled) {
        ComplianceHelper.bindApplication(context);
        try {
            AdxPreferencesHelper.getInstance().putBoolean(SP_KEY, enabled);
        }
        catch (Exception e) {
            Log.e((String)"ComplianceHelper", (String)("setGdprComplianceEnabled error" + e.getMessage()));
        }
        complianceEnabledCache.set(enabled);
    }

    public static boolean isGDPRComplianceEnabled() {
        if (!HSCoreUtil.isLauncher()) {
            return true;
        }
        return complianceEnabledCache.get();
    }
}

