/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.sdk.commonutil.pool;

import com.cloud.sdk.commonutil.pool.HSPoolExecutor;
import com.cloud.sdk.commonutil.pool.HSPoolManagerImpl;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

public class HSPoolManager
implements HSPoolManagerImpl {
    private static volatile HSPoolManager mInstance;
    private ThreadPoolExecutor executor;
    private static ThreadPoolExecutor sDefaultExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HSPoolManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<HSPoolManager> var0 = HSPoolManager.class;
        Class<HSPoolManager> clazz = HSPoolManager.class;
        synchronized (HSPoolManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new HSPoolManager();
            HSPoolManager.mInstance.executor = sDefaultExecutor != null ? sDefaultExecutor : HSPoolExecutor.newTranssionExecutor();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized HSPoolManager getInstance(int poolSize) {
        if (mInstance != null) return mInstance;
        Class<HSPoolManager> var1 = HSPoolManager.class;
        Class<HSPoolManager> clazz = HSPoolManager.class;
        synchronized (HSPoolManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new HSPoolManager();
            HSPoolManager.mInstance.executor = sDefaultExecutor != null ? sDefaultExecutor : HSPoolExecutor.newTranssionExecutor(poolSize);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void setDefaultExecutor(ThreadPoolExecutor executor) {
        sDefaultExecutor = executor;
    }

    @Override
    public void addTask(Runnable newTask) {
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                this.executor.prestartAllCoreThreads();
            }
            this.executor.execute(newTask);
        }
    }

    @Override
    public void destroy() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void purge() {
        if (this.executor != null) {
            this.executor.purge();
        }
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void execute(WeakReference<Runnable> request) {
        Runnable runnable = (Runnable)request.get();
        if (runnable != null) {
            this.addTask(runnable);
        }
    }
}

